/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.gateway.client;

import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;
import xyz.tcheeric.gateway.client.GatewayClientConfig;
import xyz.tcheeric.gateway.model.entity.GatewayEntity;
import xyz.tcheeric.gateway.model.entity.GatewayPayment;
import xyz.tcheeric.gateway.model.entity.GatewayQuote;

public abstract class AbstractBaseClient<T extends GatewayEntity> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractBaseClient.class);
    protected final RestTemplate restTemplate = new RestTemplate();
    private final String entity;
    private final Class<T> entityClass;
    private final String baseUrl;

    protected AbstractBaseClient(@NonNull String entity, @NonNull Class<T> entityClass) {
        this(null, entity, entityClass);
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        if (entityClass == null) {
            throw new NullPointerException("entityClass is marked non-null but is null");
        }
    }

    protected AbstractBaseClient(String explicitBaseUrl, @NonNull String entity, @NonNull Class<T> entityClass) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        if (entityClass == null) {
            throw new NullPointerException("entityClass is marked non-null but is null");
        }
        this.entity = entity;
        this.entityClass = entityClass;
        this.baseUrl = GatewayClientConfig.resolveBaseUrl(explicitBaseUrl);
        log.debug("Resolved gateway API base URL: {}", (Object)this.baseUrl);
    }

    public T get(@NonNull Long id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        String url = this.getUrl() + "/" + id;
        log.info("[{}] GET byId start: id={}, url={}", new Object[]{this.entity, id, url});
        ResponseEntity response = this.restTemplate.getForEntity(url, this.entityClass, new Object[0]);
        log.info("[{}] GET byId success: id={}, body={}", new Object[]{this.entity, id, response.getBody()});
        return (T)((GatewayEntity)response.getBody());
    }

    public T getByEntityId(@NonNull String entityId) {
        String url;
        if (entityId == null) {
            throw new NullPointerException("entityId is marked non-null but is null");
        }
        if (this.entityClass.equals(GatewayPayment.class)) {
            url = this.getUrl() + "/search/findByPaymentId?paymentId=" + entityId;
        } else if (this.entityClass.equals(GatewayQuote.class)) {
            url = this.getUrl() + "/search/findByQuoteId?quoteId=" + entityId;
        } else {
            throw new IllegalArgumentException("Unsupported entity type: " + this.entityClass.getName());
        }
        log.info("[{}] GET byEntityId start: entityId={}, url={}", new Object[]{this.entity, entityId, url});
        ResponseEntity response = this.restTemplate.getForEntity(url, this.entityClass, new Object[0]);
        log.info("[{}] GET byEntityId success: entityId={}, body={}", new Object[]{this.entity, entityId, response.getBody()});
        return (T)((GatewayEntity)response.getBody());
    }

    public T create(@NonNull T entity) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        String url = this.getUrl();
        log.info("[{}] POST create start: url={}", entity, (Object)url);
        HttpEntity request = new HttpEntity(entity);
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, request, this.entityClass, new Object[0]);
        log.info("[{}] POST create success: body={}", entity, response.getBody());
        return (T)((GatewayEntity)response.getBody());
    }

    public void delete(@NonNull Long id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        String url = this.getUrl() + "/" + id;
        log.info("[{}] DELETE start: id={}, url={}", new Object[]{this.entity, id, url});
        this.restTemplate.delete(url, new Object[0]);
        log.info("[{}] DELETE success: id={}", (Object)this.entity, (Object)id);
    }

    protected String getUrl() {
        return this.baseUrl + "/" + this.entity;
    }

    @Generated
    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }
}

