/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.gateway.client;

import java.io.InputStream;
import java.net.URI;
import java.util.Optional;
import java.util.Properties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GatewayClientConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GatewayClientConfig.class);
    private static final String KEY = "gateway.api.base_url";
    private static final String ENV = "GATEWAY_API_BASE_URL";
    private static final String CLASSPATH_FILE = "gateway.properties";
    private static final String KEY_PORT = "gateway.api.port";
    private static final String ENV_PORT = "GATEWAY_API_PORT";
    private static final String DEFAULT_PORT = "8080";
    private static final String DEFAULT = "http://localhost:8080";

    private GatewayClientConfig() {
    }

    static String resolveBaseUrl(String explicit) {
        String resolved = GatewayClientConfig.firstNonBlank(explicit, System.getProperty(KEY), System.getenv(ENV), GatewayClientConfig.loadFromClasspath(KEY).orElse(null), DEFAULT);
        String port = GatewayClientConfig.firstNonBlank(System.getProperty(KEY_PORT), System.getenv(ENV_PORT), GatewayClientConfig.loadFromClasspath(KEY_PORT).orElse(DEFAULT_PORT), DEFAULT_PORT);
        String normalized = GatewayClientConfig.normalize(resolved);
        String finalUrl = GatewayClientConfig.ensurePort(normalized, port);
        log.debug("Resolved gateway client base URL: {} (port={})", (Object)finalUrl, (Object)port);
        return finalUrl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Optional<String> loadFromClasspath(String key) {
        try (InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(CLASSPATH_FILE);){
            if (in == null) {
                log.trace("ClassPath properties not found: {}", (Object)CLASSPATH_FILE);
                Optional<String> optional2 = Optional.empty();
                return optional2;
            }
            Properties p = new Properties();
            p.load(in);
            String value = p.getProperty(key);
            if (value != null && !value.isBlank()) {
                log.trace("Loaded '{}' from {}", (Object)key, (Object)CLASSPATH_FILE);
            }
            Optional<String> optional = value == null || value.isBlank() ? Optional.empty() : Optional.of(value);
            return optional;
        }
        catch (Exception ignore) {
            return Optional.empty();
        }
    }

    private static String firstNonBlank(String ... values) {
        for (String v : values) {
            if (v == null || v.isBlank()) continue;
            return v;
        }
        return null;
    }

    private static String normalize(String url) {
        String trimmed = url.trim();
        return trimmed.replaceAll("/+$", "");
    }

    private static String ensurePort(String url, String port) {
        try {
            boolean hasScheme = url.matches("^[a-zA-Z][a-zA-Z0-9+.-]*://.*$");
            if (!hasScheme) {
                return "http://" + url + ":" + port;
            }
            URI uri = URI.create(url);
            if (uri.getPort() != -1) {
                return url;
            }
            String scheme = uri.getScheme();
            String host = uri.getHost();
            String authority = (String)(uri.getUserInfo() != null ? uri.getUserInfo() + "@" : "") + host + ":" + port;
            String path = uri.getRawPath() == null ? "" : uri.getRawPath();
            String query = uri.getRawQuery();
            String fragment = uri.getRawFragment();
            StringBuilder sb = new StringBuilder();
            sb.append(scheme).append("://").append(authority).append(path);
            if (query != null) {
                sb.append('?').append(query);
            }
            if (fragment != null) {
                sb.append('#').append(fragment);
            }
            return sb.toString();
        }
        catch (Exception ignore) {
            return "http://" + url + ":" + port;
        }
    }
}

