/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.gateway.dummy;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.UUID;
import lombok.NonNull;
import xyz.tcheeric.gateway.common.Gateway;

public class DummyGateway
implements Gateway {
    private static final String GATEWAY_NAME = "dummy";
    private static final Properties properties;

    public String createMintQuote(@NonNull Integer amount, String description) {
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        return UUID.randomUUID().toString();
    }

    public String createMeltQuote(@NonNull Integer amount, @NonNull String lnIvoice, String description) {
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        if (lnIvoice == null) {
            throw new NullPointerException("lnIvoice is marked non-null but is null");
        }
        return UUID.randomUUID().toString();
    }

    public String createMeltQuote(@NonNull String s) {
        if (s == null) {
            throw new NullPointerException("s is marked non-null but is null");
        }
        return UUID.randomUUID().toString();
    }

    public String getRequest(@NonNull String paymentId) {
        if (paymentId == null) {
            throw new NullPointerException("paymentId is marked non-null but is null");
        }
        return UUID.randomUUID().toString();
    }

    public boolean checkPaymentStatus(@NonNull String quoteId) {
        if (quoteId == null) {
            throw new NullPointerException("quoteId is marked non-null but is null");
        }
        return this.getPaymentStatus();
    }

    public String getPaymentPreimage(@NonNull String quoteId) {
        if (quoteId == null) {
            throw new NullPointerException("quoteId is marked non-null but is null");
        }
        return UUID.randomUUID().toString();
    }

    public String pay(@NonNull String s) {
        if (s == null) {
            throw new NullPointerException("s is marked non-null but is null");
        }
        return UUID.randomUUID().toString();
    }

    public Integer getAmount(@NonNull String quoteId) {
        if (quoteId == null) {
            throw new NullPointerException("quoteId is marked non-null but is null");
        }
        return this.getAmount();
    }

    public Integer getPaymentExpiry(@NonNull String quoteId) {
        if (quoteId == null) {
            throw new NullPointerException("quoteId is marked non-null but is null");
        }
        return this.getExpiry();
    }

    public Integer getFeeReserve(@NonNull String quoteId) {
        if (quoteId == null) {
            throw new NullPointerException("quoteId is marked non-null but is null");
        }
        return this.getFeeReserve();
    }

    public String getName() {
        return GATEWAY_NAME;
    }

    private boolean getPaymentStatus() {
        int status = Integer.parseInt(properties.getProperty("dummy.payment_status", "0"));
        return Math.random() < (double)status / 100.0;
    }

    private Integer getAmount() {
        return Integer.parseInt(properties.getProperty("dummy.amount", "0"));
    }

    private Integer getExpiry() {
        return Integer.parseInt(properties.getProperty("dummy.expiry", "0"));
    }

    private Integer getFeeReserve() {
        return Integer.parseInt(properties.getProperty("dummy.fee_reserve", "0"));
    }

    static {
        block9: {
            properties = new Properties();
            try (InputStream inputStream = DummyGateway.class.getClassLoader().getResourceAsStream("app.properties");){
                if (inputStream != null) {
                    properties.load(inputStream);
                    break block9;
                }
                throw new IllegalStateException("Could not find app.properties file in the classpath.");
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load app.properties file.", e);
            }
        }
    }
}

