/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.gateway.dummy;

import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import lombok.NonNull;
import xyz.tcheeric.cashu.common.PaymentMethod;
import xyz.tcheeric.cashu.entities.annotation.Supports;
import xyz.tcheeric.gateway.common.Gateway;

@Supports(value={PaymentMethod.BOLT11, PaymentMethod.BOLT12, PaymentMethod.ON_CHAIN})
public class DummyGateway
implements Gateway {
    private static final String GATEWAY_NAME = "dummy";
    private static final Properties properties = new Properties();
    private static final int DEFAULT_EXPIRY_SECONDS = 60;
    private static final int DEFAULT_FEE_RESERVE = 1;
    private static final Map<String, Quote> QUOTES = new ConcurrentHashMap<String, Quote>();

    public boolean supports(PaymentMethod method) {
        return method == PaymentMethod.BOLT11 || method == PaymentMethod.BOLT12 || method == PaymentMethod.ON_CHAIN;
    }

    public String createMintQuote(@NonNull Integer amount, String description) {
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        String id = UUID.randomUUID().toString();
        String req = "lnbc" + amount + "-dummy-" + id.substring(0, 8);
        int expiry = DummyGateway.getIntProp("dummy.expiry", 60);
        String preimage = DummyGateway.randomHex(32);
        QUOTES.put(id, new Quote(id, req, amount, expiry, true, preimage));
        return id;
    }

    public String createMeltQuote(@NonNull Integer amount, @NonNull String lnIvoice, String description) {
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        if (lnIvoice == null) {
            throw new NullPointerException("lnIvoice is marked non-null but is null");
        }
        String id = UUID.randomUUID().toString();
        int expiry = DummyGateway.getIntProp("dummy.expiry", 60);
        QUOTES.put(id, new Quote(id, lnIvoice, amount, expiry, false, null));
        return id;
    }

    public String createMeltQuote(@NonNull String s) {
        if (s == null) {
            throw new NullPointerException("s is marked non-null but is null");
        }
        String id = UUID.randomUUID().toString();
        int amount = DummyGateway.getIntProp("dummy.amount", 10);
        int expiry = DummyGateway.getIntProp("dummy.expiry", 60);
        QUOTES.put(id, new Quote(id, s, amount, expiry, false, null));
        return id;
    }

    public String getRequest(@NonNull String paymentId) {
        if (paymentId == null) {
            throw new NullPointerException("paymentId is marked non-null but is null");
        }
        return DummyGateway.get((String)paymentId).request;
    }

    public boolean checkPaymentStatus(@NonNull String quoteId) {
        if (quoteId == null) {
            throw new NullPointerException("quoteId is marked non-null but is null");
        }
        return DummyGateway.get((String)quoteId).paid;
    }

    public String getPaymentPreimage(@NonNull String quoteId) {
        if (quoteId == null) {
            throw new NullPointerException("quoteId is marked non-null but is null");
        }
        return DummyGateway.get((String)quoteId).preimage;
    }

    public String pay(@NonNull String s) {
        if (s == null) {
            throw new NullPointerException("s is marked non-null but is null");
        }
        Quote q = DummyGateway.get(s);
        q.paid = true;
        if (q.preimage == null || q.preimage.isBlank()) {
            q.preimage = DummyGateway.randomHex(32);
        }
        return q.preimage;
    }

    public Integer getAmount(@NonNull String quoteId) {
        if (quoteId == null) {
            throw new NullPointerException("quoteId is marked non-null but is null");
        }
        return DummyGateway.get((String)quoteId).amount;
    }

    public Integer getPaymentExpiry(@NonNull String quoteId) {
        if (quoteId == null) {
            throw new NullPointerException("quoteId is marked non-null but is null");
        }
        return DummyGateway.get((String)quoteId).expiry;
    }

    public Integer getFeeReserve(@NonNull String quoteId) {
        if (quoteId == null) {
            throw new NullPointerException("quoteId is marked non-null but is null");
        }
        return DummyGateway.getIntProp("dummy.fee_reserve", 1);
    }

    public String getName() {
        return GATEWAY_NAME;
    }

    private static Quote get(String quoteId) {
        Quote q = QUOTES.get(quoteId);
        if (q == null) {
            throw new IllegalArgumentException("Unknown quoteId: " + quoteId);
        }
        return q;
    }

    private static int getIntProp(String key, int def) {
        try {
            String v = properties.getProperty(key);
            if (v != null && !v.isBlank()) {
                return Integer.parseInt(v.trim());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return def;
    }

    private static String randomHex(int bytes) {
        byte[] b = new byte[bytes];
        new SecureRandom().nextBytes(b);
        StringBuilder sb = new StringBuilder();
        for (byte x : b) {
            sb.append(String.format("%02x", x));
        }
        return sb.toString();
    }

    @Generated
    public DummyGateway() {
    }

    static {
        try (InputStream inputStream = DummyGateway.class.getClassLoader().getResourceAsStream("dummy.properties");){
            if (inputStream != null) {
                properties.load(inputStream);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static final class Quote {
        final String id;
        final String request;
        final int amount;
        final int expiry;
        volatile boolean paid;
        volatile String preimage;

        Quote(String id, String request, int amount, int expiry, boolean paid, String preimage) {
            this.id = id;
            this.request = request;
            this.amount = amount;
            this.expiry = expiry;
            this.paid = paid;
            this.preimage = preimage;
        }
    }
}

