/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.gateway.model.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.Table;
import java.time.Instant;
import lombok.Generated;
import xyz.tcheeric.gateway.model.entity.GatewayEntity;
import xyz.tcheeric.gateway.model.entity.enums.State;

@Entity(name="payment")
@Table(indexes={@Index(name="idx_gatewaypayment_request", columnList="request"), @Index(name="idx_gatewaypayment_payment_id", columnList="payment_id"), @Index(name="idx_gatewaypayment_quote_id", columnList="quote_id")})
public class GatewayPayment
implements GatewayEntity {
    private static final long serialVersionUID = 1089714744450886412L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Long id;
    @Column(length=1024)
    private String request;
    private String paymentId;
    private String quoteId;
    @Enumerated(value=EnumType.STRING)
    private State state;
    private Instant paidDate;
    private Instant confirmedDate;
    private String sourceCurrency;
    private Integer amount;
    private Integer lightningNetworkFee;
    private Integer totalAmount;
    @Column(length=1024)
    private String paymentHash;
    @Column(length=1024)
    private String paymentPreimage;

    public static GatewayPayment create(String request, String paymentId, String quoteId, String sourceCurrency, Integer amount, Integer lightningNetworkFee, Integer totalAmount, String paymentHash, String paymentPreimage) {
        GatewayPayment payment = new GatewayPayment();
        payment.setRequest(request);
        payment.setPaymentId(paymentId);
        payment.setQuoteId(quoteId);
        payment.setSourceCurrency(sourceCurrency);
        payment.setAmount(amount);
        payment.setLightningNetworkFee(lightningNetworkFee);
        payment.setTotalAmount(totalAmount);
        payment.setPaymentHash(paymentHash);
        payment.setPaymentPreimage(paymentPreimage);
        payment.setState(State.PENDING);
        return payment;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getRequest() {
        return this.request;
    }

    @Generated
    public String getPaymentId() {
        return this.paymentId;
    }

    @Generated
    public String getQuoteId() {
        return this.quoteId;
    }

    @Generated
    public State getState() {
        return this.state;
    }

    @Generated
    public Instant getPaidDate() {
        return this.paidDate;
    }

    @Generated
    public Instant getConfirmedDate() {
        return this.confirmedDate;
    }

    @Generated
    public String getSourceCurrency() {
        return this.sourceCurrency;
    }

    @Generated
    public Integer getAmount() {
        return this.amount;
    }

    @Generated
    public Integer getLightningNetworkFee() {
        return this.lightningNetworkFee;
    }

    @Generated
    public Integer getTotalAmount() {
        return this.totalAmount;
    }

    @Generated
    public String getPaymentHash() {
        return this.paymentHash;
    }

    @Generated
    public String getPaymentPreimage() {
        return this.paymentPreimage;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setRequest(String request) {
        this.request = request;
    }

    @Generated
    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    @Generated
    public void setQuoteId(String quoteId) {
        this.quoteId = quoteId;
    }

    @Generated
    public void setState(State state) {
        this.state = state;
    }

    @Generated
    public void setPaidDate(Instant paidDate) {
        this.paidDate = paidDate;
    }

    @Generated
    public void setConfirmedDate(Instant confirmedDate) {
        this.confirmedDate = confirmedDate;
    }

    @Generated
    public void setSourceCurrency(String sourceCurrency) {
        this.sourceCurrency = sourceCurrency;
    }

    @Generated
    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    @Generated
    public void setLightningNetworkFee(Integer lightningNetworkFee) {
        this.lightningNetworkFee = lightningNetworkFee;
    }

    @Generated
    public void setTotalAmount(Integer totalAmount) {
        this.totalAmount = totalAmount;
    }

    @Generated
    public void setPaymentHash(String paymentHash) {
        this.paymentHash = paymentHash;
    }

    @Generated
    public void setPaymentPreimage(String paymentPreimage) {
        this.paymentPreimage = paymentPreimage;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GatewayPayment)) {
            return false;
        }
        GatewayPayment other = (GatewayPayment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$amount = this.getAmount();
        Integer other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Integer this$lightningNetworkFee = this.getLightningNetworkFee();
        Integer other$lightningNetworkFee = other.getLightningNetworkFee();
        if (this$lightningNetworkFee == null ? other$lightningNetworkFee != null : !((Object)this$lightningNetworkFee).equals(other$lightningNetworkFee)) {
            return false;
        }
        Integer this$totalAmount = this.getTotalAmount();
        Integer other$totalAmount = other.getTotalAmount();
        if (this$totalAmount == null ? other$totalAmount != null : !((Object)this$totalAmount).equals(other$totalAmount)) {
            return false;
        }
        String this$request = this.getRequest();
        String other$request = other.getRequest();
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        String this$paymentId = this.getPaymentId();
        String other$paymentId = other.getPaymentId();
        if (this$paymentId == null ? other$paymentId != null : !this$paymentId.equals(other$paymentId)) {
            return false;
        }
        String this$quoteId = this.getQuoteId();
        String other$quoteId = other.getQuoteId();
        if (this$quoteId == null ? other$quoteId != null : !this$quoteId.equals(other$quoteId)) {
            return false;
        }
        State this$state = this.getState();
        State other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
            return false;
        }
        Instant this$paidDate = this.getPaidDate();
        Instant other$paidDate = other.getPaidDate();
        if (this$paidDate == null ? other$paidDate != null : !((Object)this$paidDate).equals(other$paidDate)) {
            return false;
        }
        Instant this$confirmedDate = this.getConfirmedDate();
        Instant other$confirmedDate = other.getConfirmedDate();
        if (this$confirmedDate == null ? other$confirmedDate != null : !((Object)this$confirmedDate).equals(other$confirmedDate)) {
            return false;
        }
        String this$sourceCurrency = this.getSourceCurrency();
        String other$sourceCurrency = other.getSourceCurrency();
        if (this$sourceCurrency == null ? other$sourceCurrency != null : !this$sourceCurrency.equals(other$sourceCurrency)) {
            return false;
        }
        String this$paymentHash = this.getPaymentHash();
        String other$paymentHash = other.getPaymentHash();
        if (this$paymentHash == null ? other$paymentHash != null : !this$paymentHash.equals(other$paymentHash)) {
            return false;
        }
        String this$paymentPreimage = this.getPaymentPreimage();
        String other$paymentPreimage = other.getPaymentPreimage();
        return !(this$paymentPreimage == null ? other$paymentPreimage != null : !this$paymentPreimage.equals(other$paymentPreimage));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GatewayPayment;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Integer $lightningNetworkFee = this.getLightningNetworkFee();
        result = result * 59 + ($lightningNetworkFee == null ? 43 : ((Object)$lightningNetworkFee).hashCode());
        Integer $totalAmount = this.getTotalAmount();
        result = result * 59 + ($totalAmount == null ? 43 : ((Object)$totalAmount).hashCode());
        String $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        String $paymentId = this.getPaymentId();
        result = result * 59 + ($paymentId == null ? 43 : $paymentId.hashCode());
        String $quoteId = this.getQuoteId();
        result = result * 59 + ($quoteId == null ? 43 : $quoteId.hashCode());
        State $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        Instant $paidDate = this.getPaidDate();
        result = result * 59 + ($paidDate == null ? 43 : ((Object)$paidDate).hashCode());
        Instant $confirmedDate = this.getConfirmedDate();
        result = result * 59 + ($confirmedDate == null ? 43 : ((Object)$confirmedDate).hashCode());
        String $sourceCurrency = this.getSourceCurrency();
        result = result * 59 + ($sourceCurrency == null ? 43 : $sourceCurrency.hashCode());
        String $paymentHash = this.getPaymentHash();
        result = result * 59 + ($paymentHash == null ? 43 : $paymentHash.hashCode());
        String $paymentPreimage = this.getPaymentPreimage();
        result = result * 59 + ($paymentPreimage == null ? 43 : $paymentPreimage.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GatewayPayment(id=" + this.getId() + ", request=" + this.getRequest() + ", paymentId=" + this.getPaymentId() + ", quoteId=" + this.getQuoteId() + ", state=" + String.valueOf((Object)this.getState()) + ", paidDate=" + String.valueOf(this.getPaidDate()) + ", confirmedDate=" + String.valueOf(this.getConfirmedDate()) + ", sourceCurrency=" + this.getSourceCurrency() + ", amount=" + this.getAmount() + ", lightningNetworkFee=" + this.getLightningNetworkFee() + ", totalAmount=" + this.getTotalAmount() + ", paymentHash=" + this.getPaymentHash() + ", paymentPreimage=" + this.getPaymentPreimage() + ")";
    }

    @Generated
    public GatewayPayment() {
    }
}

