/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.gateway.phoenixd;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.time.Instant;
import java.util.Base64;
import java.util.Properties;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;
import xyz.tcheeric.cashu.common.PaymentMethod;
import xyz.tcheeric.cashu.entities.annotation.Supports;
import xyz.tcheeric.gateway.client.PaymentClient;
import xyz.tcheeric.gateway.client.QuoteClient;
import xyz.tcheeric.gateway.common.Gateway;
import xyz.tcheeric.gateway.model.entity.GatewayEntity;
import xyz.tcheeric.gateway.model.entity.GatewayPayment;
import xyz.tcheeric.gateway.model.entity.GatewayQuote;
import xyz.tcheeric.gateway.model.entity.enums.Direction;
import xyz.tcheeric.gateway.model.entity.enums.State;
import xyz.tcheeric.gateway.phoenixd.service.PhoenixdService;
import xyz.tcheeric.gateway.phoenixd.service.PhoenixdServiceImpl;
import xyz.tcheeric.phoenixd.model.param.CreateInvoiceParam;
import xyz.tcheeric.phoenixd.model.param.DecodeInvoiceParam;
import xyz.tcheeric.phoenixd.model.param.PayBolt11InvoiceParam;
import xyz.tcheeric.phoenixd.model.param.PayLightningAddressParam;
import xyz.tcheeric.phoenixd.model.response.CreateInvoiceResponse;
import xyz.tcheeric.phoenixd.model.response.DecodeInvoiceResponse;
import xyz.tcheeric.phoenixd.model.response.GetLightningAddressResponse;
import xyz.tcheeric.phoenixd.model.response.PayInvoiceResponse;
import xyz.tcheeric.phoenixd.model.response.PayLightningAddressInvoiceResponse;

@Component
@PropertySource(value={"classpath:phoenixd.properties"})
@Supports(value={PaymentMethod.BOLT11, PaymentMethod.BOLT12, PaymentMethod.ON_CHAIN})
public class PhoenixdGateway
implements Gateway {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PhoenixdGateway.class);
    private static final String GATEWAY_NAME = "phoenixd";
    @Value(value="${phoenixd.currency}")
    private String currency;
    @Value(value="${phoenixd.expiry}")
    private int expiry;
    @Value(value="${phoenixd.lnaddress:off}")
    private String lnAddressFlag;
    @Value(value="${phoenixd.fee.percent}")
    private double feePercent;
    @Value(value="${phoenixd.fee.fixed}")
    private int fixedFee;
    @Value(value="${webhook.base_url}")
    private String webhookBaseUrl;
    private PhoenixdService service = new PhoenixdServiceImpl();

    public PhoenixdGateway() {
        this.loadPropertiesIfNeeded();
    }

    public PhoenixdGateway(PhoenixdService service) {
        this.service = service;
        this.loadPropertiesIfNeeded();
    }

    public String createMintQuote(Integer amount, String description) {
        log.info("Creating mint quote: amount={}, description={}", (Object)amount, (Object)description);
        CreateInvoiceParam param = new CreateInvoiceParam();
        param.setDescription(description);
        param.setAmountSat(amount);
        param.setExpirySeconds(Integer.valueOf(this.expiry));
        param.setExternalId(UUID.randomUUID().toString());
        param.setWebhookUrl(this.getWebhookUrl());
        CreateInvoiceResponse response = this.service.createInvoice(param);
        GatewayQuote quote = new GatewayQuote();
        quote.setQuoteId(UUID.randomUUID().toString());
        quote.setInvoiceId(param.getExternalId());
        quote.setExpiry(param.getExpirySeconds());
        quote.setDescription(param.getDescription());
        quote.setAmount(response.getAmountSat());
        quote.setUnit(this.currency);
        quote.setRequest(this.getRequest(response));
        quote.setState(State.PENDING);
        quote.setDirection(Direction.RECEIVE);
        QuoteClient quoteClient = new QuoteClient();
        quoteClient.create((GatewayEntity)quote);
        log.info("Created mint quote: quoteId={}", (Object)quote.getQuoteId());
        return quote.getQuoteId();
    }

    public String createMeltQuote(String request) {
        log.info("Creating melt quote for request {}", (Object)request);
        if (request.startsWith("lnbc") || request.startsWith("lntb") || request.startsWith("lntbs")) {
            return this.createMeltQuoteLnInvoice(request);
        }
        return this.createMeltQuoteLnAddress(request);
    }

    public String createMeltQuote(Integer amount, String request, String description) {
        log.info("Creating melt quote: amount={}, description={} request={}", new Object[]{amount, description, request});
        CreateInvoiceParam param = new CreateInvoiceParam();
        param.setDescription(description);
        param.setAmountSat(amount);
        param.setExpirySeconds(Integer.valueOf(this.expiry));
        param.setExternalId(UUID.randomUUID().toString());
        GatewayQuote quote = new GatewayQuote();
        quote.setQuoteId(UUID.randomUUID().toString());
        quote.setInvoiceId(param.getExternalId());
        quote.setExpiry(param.getExpirySeconds());
        quote.setDescription(param.getDescription());
        quote.setAmount(amount);
        quote.setUnit(this.currency);
        quote.setRequest(request);
        quote.setState(State.PENDING);
        quote.setDirection(Direction.SEND);
        QuoteClient quoteClient = new QuoteClient();
        quoteClient.create((GatewayEntity)quote);
        log.info("Created melt quote: quoteId={}", (Object)quote.getQuoteId());
        return quote.getQuoteId();
    }

    public String getRequest(String quoteId) {
        QuoteClient quoteClient = new QuoteClient();
        GatewayQuote quote = (GatewayQuote)quoteClient.getByEntityId(quoteId);
        log.debug("Retrieved request for quoteId={}", (Object)quoteId);
        return quote.getRequest();
    }

    public boolean checkPaymentStatus(String quoteId) {
        QuoteClient quoteClient = new QuoteClient();
        GatewayPayment payment = new PaymentClient().getByQuoteId(quoteId);
        log.debug("Checked payment status for quoteId={}, state={}", (Object)quoteId, (Object)payment.getState());
        return State.PAID.equals((Object)payment.getState());
    }

    public String getPaymentPreimage(String quoteId) {
        PaymentClient client = new PaymentClient();
        GatewayPayment payment = client.getByQuoteId(quoteId);
        log.debug("Retrieved payment preimage for quoteId={}", (Object)quoteId);
        return payment.getPaymentId();
    }

    public String pay(String quoteId) {
        PayLightningAddressInvoiceResponse response;
        log.info("Paying quote: quoteId={}", (Object)quoteId);
        QuoteClient quoteClient = new QuoteClient();
        GatewayQuote quote = (GatewayQuote)quoteClient.getByEntityId(quoteId);
        String request = quote.getRequest();
        if (request == null) {
            throw new IllegalStateException("Missing payment request");
        }
        if (request.contains("@")) {
            param = new PayLightningAddressParam();
            param.setAmountSat(quote.getAmount());
            param.setAddress(request);
            response = this.service.payLightningAddress(param);
        } else {
            param = new PayBolt11InvoiceParam();
            param.setAmountSat(quote.getAmount());
            param.setInvoice(request);
            response = this.service.payBolt11Invoice((PayBolt11InvoiceParam)param);
        }
        if (response == null) {
            throw new IllegalStateException("Null response from phoenixd service");
        }
        PayInvoiceResponse payInvoiceResponse = (PayInvoiceResponse)response;
        if (payInvoiceResponse.getReason() != null) {
            throw new IllegalStateException("Payment failed: " + payInvoiceResponse.getReason());
        }
        GatewayPayment payment = new GatewayPayment();
        payment.setPaymentId(payInvoiceResponse.getPaymentId());
        payment.setRequest(request);
        payment.setQuoteId(quoteId);
        payment.setSourceCurrency(this.currency);
        payment.setPaymentHash(payInvoiceResponse.getPaymentHash());
        payment.setPaymentPreimage(payInvoiceResponse.getPaymentPreimage());
        payment.setLightningNetworkFee(payInvoiceResponse.getRoutingFeeSat());
        payment.setAmount(payInvoiceResponse.getRecipientAmountSat());
        payment.setState(State.PAID);
        payment.setPaidDate(Instant.now());
        payment.setConfirmedDate(null);
        PaymentClient client = new PaymentClient();
        client.create((GatewayEntity)payment);
        log.info("Payment sent: paymentId={}", (Object)payInvoiceResponse.getPaymentId());
        return payInvoiceResponse.getPaymentId();
    }

    public Integer getAmount(String quoteId) {
        QuoteClient client = new QuoteClient();
        GatewayQuote quote = (GatewayQuote)client.getByEntityId(quoteId);
        return quote.getAmount();
    }

    public Integer getPaymentExpiry(String quoteId) {
        QuoteClient client = new QuoteClient();
        GatewayQuote quote = (GatewayQuote)client.getByEntityId(quoteId);
        return quote.getExpiry();
    }

    public Integer getFeeReserve(String quoteId) {
        GatewayQuote quote = (GatewayQuote)new QuoteClient().getByEntityId(quoteId);
        Integer amount = quote.getAmount();
        return (int)Math.round((double)amount.intValue() * this.feePercent) + this.fixedFee;
    }

    public String getName() {
        return GATEWAY_NAME;
    }

    private String createMeltQuoteLnInvoice(@NonNull String lnInvoice) {
        if (lnInvoice == null) {
            throw new NullPointerException("lnInvoice is marked non-null but is null");
        }
        DecodeInvoiceParam param = new DecodeInvoiceParam();
        param.setInvoice(lnInvoice);
        DecodeInvoiceResponse decodeInvoiceResponse = this.service.decodeInvoice(param);
        return this.createMeltQuote(decodeInvoiceResponse.getAmount(), lnInvoice, decodeInvoiceResponse.getDescription());
    }

    private String createMeltQuoteLnAddress(@NonNull String request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        try {
            byte[] decodedBytes = Base64.getDecoder().decode(request);
            String decodedString = new String(decodedBytes);
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode jsonNode = objectMapper.readTree(decodedString);
            String lnAddress = jsonNode.get("lnAddress").asText();
            int amount = jsonNode.get("amount").asInt();
            String description = jsonNode.get("description").asText();
            return this.createMeltQuote(amount, lnAddress, description);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to decode and parse the request", e);
        }
    }

    private URL getWebhookUrl() {
        try {
            if (this.webhookBaseUrl == null || this.webhookBaseUrl.isBlank()) {
                throw new IllegalStateException("Missing configuration: 'webhook.base_url' is not set. Ensure phoenixd.properties is on the classpath or Spring @Value injection is configured.");
            }
            String normalized = this.webhookBaseUrl.replaceAll("/+$", "");
            return URI.create(normalized + "/phoenixd").toURL();
        }
        catch (MalformedURLException e) {
            log.error("Invalid webhook base URL: {}", (Object)this.webhookBaseUrl, (Object)e);
            throw new RuntimeException(e);
        }
    }

    private void loadPropertiesIfNeeded() {
        boolean needsLoad;
        boolean bl = needsLoad = this.currency == null || this.lnAddressFlag == null || this.webhookBaseUrl == null;
        if (!needsLoad) {
            return;
        }
        try (InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("phoenixd.properties");){
            String timeout;
            String pass;
            String user;
            if (in == null) {
                log.warn("phoenixd.properties not found on classpath; relying on defaults/@Value");
                if (this.currency == null) {
                    this.currency = "sat";
                }
                if (this.lnAddressFlag == null) {
                    this.lnAddressFlag = "off";
                }
                return;
            }
            Properties p = new Properties();
            p.load(in);
            if (this.currency == null) {
                this.currency = p.getProperty("phoenixd.currency", "sat");
            }
            if (this.expiry == 0) {
                String exp = p.getProperty("phoenixd.expiry", p.getProperty("phoenixd.expiration", "60"));
                try {
                    this.expiry = Integer.parseInt(exp);
                }
                catch (NumberFormatException ignored) {
                    this.expiry = 60;
                }
            }
            if (this.lnAddressFlag == null) {
                this.lnAddressFlag = p.getProperty("phoenixd.lnaddress", "off");
            }
            if (this.feePercent == 0.0) {
                String fp = p.getProperty("phoenixd.fee.percent", "0.0");
                try {
                    this.feePercent = Double.parseDouble(fp);
                }
                catch (NumberFormatException ignored) {
                    // empty catch block
                }
            }
            if (this.fixedFee == 0) {
                String ff = p.getProperty("phoenixd.fee.fixed", "0");
                try {
                    this.fixedFee = Integer.parseInt(ff);
                }
                catch (NumberFormatException ignored) {
                    // empty catch block
                }
            }
            if (this.webhookBaseUrl == null) {
                this.webhookBaseUrl = p.getProperty("webhook.base_url");
            }
            String baseUrl = p.getProperty("phoenixd.base_url", "http://localhost:9740");
            if (System.getProperty("phoenixd.base_url") == null || System.getProperty("phoenixd.base_url").isBlank()) {
                System.setProperty("phoenixd.base_url", baseUrl);
            }
            if (!(user = p.getProperty("phoenixd.username", "")).isBlank() && System.getProperty("phoenixd.username") == null) {
                System.setProperty("phoenixd.username", user);
            }
            if (!(pass = p.getProperty("phoenixd.password", "")).isBlank() && System.getProperty("phoenixd.password") == null) {
                System.setProperty("phoenixd.password", pass);
            }
            if (!(timeout = p.getProperty("phoenixd.timeout", "")).isBlank() && System.getProperty("phoenixd.timeout") == null) {
                System.setProperty("phoenixd.timeout", timeout);
            }
        }
        catch (Exception e) {
            log.error("Failed to load phoenixd.properties from classpath", (Throwable)e);
        }
    }

    private String getRequest(@NonNull CreateInvoiceResponse response) {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        boolean lnAddressFlag = this.lnAddressFlag.equalsIgnoreCase("on");
        return lnAddressFlag ? this.getLightningAddress() : response.getSerialized();
    }

    private String getLightningAddress() {
        GetLightningAddressResponse resp = this.service.getLightningAddress();
        return resp.getLightningAddress();
    }
}

