/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.common;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.Generated;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.common.Signature;
import xyz.tcheeric.cashu.common.Witness;
import xyz.tcheeric.cashu.common.json.deserializer.SecretDeserializer;

@JsonPropertyOrder(value={"amount", "id", "secret", "C", "witness"})
public class Proof<T extends Secret> {
    @JsonProperty
    private int amount;
    @JsonProperty
    @JsonDeserialize(using=SecretDeserializer.class)
    private T secret;
    @JsonProperty(value="id")
    private String keySetId;
    @JsonProperty(value="C")
    private Signature unblindedSignature;
    @JsonProperty(value="witness")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Witness witness;

    public void setSecretData(byte[] data) {
        this.secret.setData(data);
    }

    @Generated
    public static <T extends Secret> ProofBuilder<T> builder() {
        return new ProofBuilder();
    }

    @Generated
    public int getAmount() {
        return this.amount;
    }

    @Generated
    public T getSecret() {
        return this.secret;
    }

    @Generated
    public String getKeySetId() {
        return this.keySetId;
    }

    @Generated
    public Signature getUnblindedSignature() {
        return this.unblindedSignature;
    }

    @Generated
    public Witness getWitness() {
        return this.witness;
    }

    @JsonProperty
    @Generated
    public void setAmount(int amount) {
        this.amount = amount;
    }

    @JsonProperty
    @JsonDeserialize(using=SecretDeserializer.class)
    @Generated
    public void setSecret(T secret) {
        this.secret = secret;
    }

    @JsonProperty(value="id")
    @Generated
    public void setKeySetId(String keySetId) {
        this.keySetId = keySetId;
    }

    @JsonProperty(value="C")
    @Generated
    public void setUnblindedSignature(Signature unblindedSignature) {
        this.unblindedSignature = unblindedSignature;
    }

    @JsonProperty(value="witness")
    @Generated
    public void setWitness(Witness witness) {
        this.witness = witness;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Proof)) {
            return false;
        }
        Proof other = (Proof)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getAmount() != other.getAmount()) {
            return false;
        }
        T this$secret = this.getSecret();
        T other$secret = other.getSecret();
        if (this$secret == null ? other$secret != null : !this$secret.equals(other$secret)) {
            return false;
        }
        String this$keySetId = this.getKeySetId();
        String other$keySetId = other.getKeySetId();
        if (this$keySetId == null ? other$keySetId != null : !this$keySetId.equals(other$keySetId)) {
            return false;
        }
        Signature this$unblindedSignature = this.getUnblindedSignature();
        Signature other$unblindedSignature = other.getUnblindedSignature();
        if (this$unblindedSignature == null ? other$unblindedSignature != null : !((Object)this$unblindedSignature).equals(other$unblindedSignature)) {
            return false;
        }
        Witness this$witness = this.getWitness();
        Witness other$witness = other.getWitness();
        return !(this$witness == null ? other$witness != null : !((Object)this$witness).equals(other$witness));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Proof;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getAmount();
        T $secret = this.getSecret();
        result = result * 59 + ($secret == null ? 43 : $secret.hashCode());
        String $keySetId = this.getKeySetId();
        result = result * 59 + ($keySetId == null ? 43 : $keySetId.hashCode());
        Signature $unblindedSignature = this.getUnblindedSignature();
        result = result * 59 + ($unblindedSignature == null ? 43 : ((Object)$unblindedSignature).hashCode());
        Witness $witness = this.getWitness();
        result = result * 59 + ($witness == null ? 43 : ((Object)$witness).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Proof(amount=" + this.getAmount() + ", secret=" + String.valueOf(this.getSecret()) + ", keySetId=" + this.getKeySetId() + ", unblindedSignature=" + String.valueOf(this.getUnblindedSignature()) + ", witness=" + String.valueOf(this.getWitness()) + ")";
    }

    @Generated
    public Proof(int amount, T secret, String keySetId, Signature unblindedSignature, Witness witness) {
        this.amount = amount;
        this.secret = secret;
        this.keySetId = keySetId;
        this.unblindedSignature = unblindedSignature;
        this.witness = witness;
    }

    @Generated
    public Proof() {
    }

    @Generated
    public static class ProofBuilder<T extends Secret> {
        @Generated
        private int amount;
        @Generated
        private T secret;
        @Generated
        private String keySetId;
        @Generated
        private Signature unblindedSignature;
        @Generated
        private Witness witness;

        @Generated
        ProofBuilder() {
        }

        @JsonProperty
        @Generated
        public ProofBuilder<T> amount(int amount) {
            this.amount = amount;
            return this;
        }

        @JsonProperty
        @JsonDeserialize(using=SecretDeserializer.class)
        @Generated
        public ProofBuilder<T> secret(T secret) {
            this.secret = secret;
            return this;
        }

        @JsonProperty(value="id")
        @Generated
        public ProofBuilder<T> keySetId(String keySetId) {
            this.keySetId = keySetId;
            return this;
        }

        @JsonProperty(value="C")
        @Generated
        public ProofBuilder<T> unblindedSignature(Signature unblindedSignature) {
            this.unblindedSignature = unblindedSignature;
            return this;
        }

        @JsonProperty(value="witness")
        @Generated
        public ProofBuilder<T> witness(Witness witness) {
            this.witness = witness;
            return this;
        }

        @Generated
        public Proof<T> build() {
            return new Proof<T>(this.amount, this.secret, this.keySetId, this.unblindedSignature, this.witness);
        }

        @Generated
        public String toString() {
            return "Proof.ProofBuilder(amount=" + this.amount + ", secret=" + String.valueOf(this.secret) + ", keySetId=" + this.keySetId + ", unblindedSignature=" + String.valueOf(this.unblindedSignature) + ", witness=" + String.valueOf(this.witness) + ")";
        }
    }
}

