/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import lombok.NonNull;
import org.bouncycastle.util.encoders.Hex;
import xyz.tcheeric.cashu.common.BaseKey;
import xyz.tcheeric.cashu.common.CompressedPublicKey;
import xyz.tcheeric.cashu.common.PrivateKey;
import xyz.tcheeric.cashu.common.UnCompressedPublicKey;

public class PublicKey
extends BaseKey {
    private Object data;

    protected PublicKey(@NonNull Object data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        this.data = data;
        if (data instanceof String) {
            this.setBytes(Hex.decode((String)((String)data)));
        } else if (data instanceof byte[]) {
            this.setBytes((byte[])data);
        } else {
            throw new IllegalArgumentException("data must be String or byte[]");
        }
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static PublicKey fromString(@NonNull String s) {
        if (s == null) {
            throw new NullPointerException("s is marked non-null but is null");
        }
        return new CompressedPublicKey(s);
    }

    public static PublicKey fromBytes(byte[] bytes) {
        return new UnCompressedPublicKey(bytes);
    }

    public byte[] getSchnorr() {
        return Hex.decode((String)this.toString().substring(2));
    }

    public static byte[] getSchnorr(@NonNull PublicKey publicKey) {
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        return publicKey.getSchnorr();
    }

    public static PublicKey derivePublicKey(@NonNull PrivateKey privateKey) {
        if (privateKey == null) {
            throw new NullPointerException("privateKey is marked non-null but is null");
        }
        return PrivateKey.derivePublicKey(privateKey);
    }

    public static PublicKey derivePublicKey(@NonNull String privateKey) {
        if (privateKey == null) {
            throw new NullPointerException("privateKey is marked non-null but is null");
        }
        return PublicKey.derivePublicKey(PrivateKey.fromString(privateKey));
    }

    @Override
    public String toString() {
        if (this.isUnCompressed()) {
            return UnCompressedPublicKey.compress(new UnCompressedPublicKey(this.getBytes())).toString();
        }
        return Hex.toHexString((byte[])this.getBytes());
    }

    protected static byte[] toFixed32(byte[] src) {
        if (src.length == 32) {
            return src;
        }
        byte[] out = new byte[32];
        if (src.length > 32) {
            System.arraycopy(src, src.length - 32, out, 0, 32);
        } else {
            System.arraycopy(src, 0, out, 32 - src.length, src.length);
        }
        return out;
    }

    private boolean isUnCompressed() {
        return this.data instanceof byte[];
    }
}

