/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.common;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.math.BigInteger;
import java.security.SecureRandom;
import lombok.NonNull;
import xyz.tcheeric.cashu.common.PrivateKey;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.common.json.deserializer.RandomStringSecretDeserializer;
import xyz.tcheeric.cashu.crypto.util.Utils;

@JsonDeserialize(using=RandomStringSecretDeserializer.class)
public class RandomStringSecret
extends PrivateKey
implements Secret {
    private RandomStringSecret(@NonNull String value) {
        super(value);
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
    }

    private RandomStringSecret(byte[] value) {
        super(value);
    }

    public static RandomStringSecret create() {
        byte[] bytes = new byte[32];
        new SecureRandom().nextBytes(bytes);
        return new RandomStringSecret(bytes);
    }

    @Override
    public byte[] getData() {
        return this.getBytes();
    }

    @Override
    public void setData(@NonNull byte[] data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
    }

    public static RandomStringSecret fromString(@NonNull String s) {
        if (s == null) {
            throw new NullPointerException("s is marked non-null but is null");
        }
        return new RandomStringSecret(s);
    }

    public static RandomStringSecret fromBytes(byte[] bytes) {
        return new RandomStringSecret(bytes);
    }

    public static RandomStringSecret fromBigInteger(@NonNull BigInteger b) {
        if (b == null) {
            throw new NullPointerException("b is marked non-null but is null");
        }
        return RandomStringSecret.fromString(Utils.bytesToHexString((byte[])b.toByteArray()));
    }
}

