/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.common.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import xyz.tcheeric.cashu.common.RandomStringSecret;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.common.WellKnownSecret;
import xyz.tcheeric.cashu.common.util.JsonUtils;

public final class SecretUtil<T extends Secret> {
    private static final ObjectMapper MAPPER = JsonUtils.JSON_MAPPER;

    public static <T extends Secret> T toSecret(@NonNull Object value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (value instanceof Secret) {
            Secret secret = (Secret)value;
            return (T)secret;
        }
        if (value instanceof String) {
            String str = (String)value;
            return (T)RandomStringSecret.fromString(str);
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return SecretUtil.mapToSecret(map);
        }
        if (value instanceof List) {
            List list = (List)value;
            return SecretUtil.listToSecret(list);
        }
        throw new IllegalArgumentException("Unknown secret type");
    }

    private static <T extends Secret> T listToSecret(List<?> list) {
        Map<Object, Object> second;
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Unknown secret type");
        }
        String kind = String.valueOf(list.get(0));
        Map<Object, Object> map = second = list.size() > 1 ? list.get(1) : Map.of();
        if (!(second instanceof Map)) {
            throw new IllegalArgumentException("Unknown secret type");
        }
        Map<Object, Object> data = second;
        HashMap<String, String> map2 = new HashMap<String, String>();
        data.forEach((k, v) -> map2.put(String.valueOf(k), (String)v));
        map2.put("kind", kind);
        return (T)((Secret)MAPPER.convertValue(map2, WellKnownSecret.class));
    }

    private static <T extends Secret> T mapToSecret(Map<?, ?> src) {
        HashMap map = new HashMap();
        src.forEach((k, v) -> map.put(String.valueOf(k), v));
        if (!map.containsKey("kind")) {
            throw new IllegalArgumentException("Unknown secret type");
        }
        return (T)((Secret)MAPPER.convertValue(map, WellKnownSecret.class));
    }
}

