/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import lombok.NonNull;
import org.bouncycastle.util.encoders.Hex;
import xyz.tcheeric.cashu.common.PublicKey;

public class CompressedPublicKey
extends PublicKey {
    CompressedPublicKey(@NonNull String s) {
        super((Object)s);
        if (s == null) {
            throw new NullPointerException("s is marked non-null but is null");
        }
        if (s.length() != 66) {
            throw new IllegalArgumentException("Invalid compressed public key length (" + s.length() + ")");
        }
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static CompressedPublicKey fromString(@NonNull String s) {
        if (s == null) {
            throw new NullPointerException("s is marked non-null but is null");
        }
        return new CompressedPublicKey(s);
    }

    @Override
    public String toString() {
        return Hex.toHexString((byte[])this.getBytes());
    }

    protected static String toString(CompressedPublicKey publicKey) {
        return publicKey.toString();
    }
}

