/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.Generated;
import lombok.NonNull;

public class KeysetId {
    public static final int KEYSET_ID_LENGTH = 16;
    private final String value;

    private KeysetId(@NonNull String value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (!value.matches("^[0-9a-fA-F]{16}$")) {
            throw new IllegalArgumentException("Invalid keyset id: " + value);
        }
        this.value = value.toLowerCase();
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static KeysetId fromString(@NonNull String value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return new KeysetId(value);
    }

    @JsonValue
    public String toString() {
        return this.value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeysetId)) {
            return false;
        }
        KeysetId other = (KeysetId)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$value = this.value;
        String other$value = other.value;
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KeysetId;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.value;
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}

