/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import lombok.NonNull;
import org.bouncycastle.util.encoders.Hex;
import xyz.tcheeric.cashu.common.CompressedPublicKey;
import xyz.tcheeric.cashu.common.PublicKey;
import xyz.tcheeric.cashu.crypto.util.Point;

public class UnCompressedPublicKey
extends PublicKey {
    UnCompressedPublicKey(@NonNull byte[] bytes) {
        super((Object)bytes);
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        if (bytes.length != 64) {
            throw new IllegalArgumentException("Invalid uncompressed public key length (" + bytes.length + ")");
        }
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static UnCompressedPublicKey fromBytes(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        return new UnCompressedPublicKey(bytes);
    }

    @Override
    public String toString() {
        return UnCompressedPublicKey.compress(this).toString();
    }

    static CompressedPublicKey compress(UnCompressedPublicKey unCompressedPublicKey) {
        Point point = new Point(Hex.toHexString((byte[])unCompressedPublicKey.getBytes()));
        String prefix = point.hasEvenY() ? "02" : "03";
        byte[] bytes = UnCompressedPublicKey.toFixed32(point.getX().toByteArray());
        return CompressedPublicKey.fromString(prefix + Hex.toHexString((byte[])bytes));
    }
}

