/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.common.util;

import java.util.Arrays;
import lombok.Generated;
import xyz.tcheeric.cashu.common.P2PKSecret;
import xyz.tcheeric.cashu.common.RandomStringSecret;
import xyz.tcheeric.cashu.common.Secret;

public class SecretFactory<T extends Secret> {
    private byte[] p2pkPublicKey;

    public T create() {
        if (this.p2pkPublicKey == null) {
            return (T)RandomStringSecret.create();
        }
        return (T)new P2PKSecret(this.p2pkPublicKey);
    }

    public static <T extends Secret> T create(byte[] p2pkPublicKey) {
        return new SecretFactory<T>(p2pkPublicKey).create();
    }

    @Generated
    public byte[] getP2pkPublicKey() {
        return this.p2pkPublicKey;
    }

    @Generated
    public void setP2pkPublicKey(byte[] p2pkPublicKey) {
        this.p2pkPublicKey = p2pkPublicKey;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SecretFactory)) {
            return false;
        }
        SecretFactory other = (SecretFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.equals(this.getP2pkPublicKey(), other.getP2pkPublicKey());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SecretFactory;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getP2pkPublicKey());
        return result;
    }

    @Generated
    public String toString() {
        return "SecretFactory(p2pkPublicKey=" + Arrays.toString(this.getP2pkPublicKey()) + ")";
    }

    @Generated
    public SecretFactory() {
    }

    @Generated
    public SecretFactory(byte[] p2pkPublicKey) {
        this.p2pkPublicKey = p2pkPublicKey;
    }
}

