/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.common;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.math.BigInteger;
import java.security.SecureRandom;
import lombok.NonNull;
import org.bouncycastle.util.encoders.Hex;
import xyz.tcheeric.cashu.common.BaseKey;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.common.json.deserializer.RandomStringSecretDeserializer;
import xyz.tcheeric.cashu.crypto.util.Utils;

@JsonDeserialize(using=RandomStringSecretDeserializer.class)
public class RandomStringSecret
extends BaseKey
implements Secret {
    private RandomStringSecret(@NonNull String value) {
        this(Hex.decode((String)value));
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
    }

    private RandomStringSecret(byte[] value) {
        super(value);
    }

    public static RandomStringSecret create() {
        return RandomStringSecret.create(32);
    }

    public static RandomStringSecret create(int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("Length must be positive, got: " + length);
        }
        byte[] bytes = new byte[length];
        new SecureRandom().nextBytes(bytes);
        return new RandomStringSecret(bytes);
    }

    @Override
    public byte[] getData() {
        return this.getBytes();
    }

    @Override
    public void setData(@NonNull byte[] data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
    }

    public static RandomStringSecret fromString(@NonNull String s) {
        if (s == null) {
            throw new NullPointerException("s is marked non-null but is null");
        }
        return new RandomStringSecret(s);
    }

    public static RandomStringSecret fromBytes(byte[] bytes) {
        return new RandomStringSecret(bytes);
    }

    public static RandomStringSecret fromBigInteger(@NonNull BigInteger b) {
        if (b == null) {
            throw new NullPointerException("b is marked non-null but is null");
        }
        return RandomStringSecret.fromString(Utils.bytesToHexString((byte[])b.toByteArray()));
    }
}

