/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.common;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import lombok.NonNull;

public interface Token {
    public static final String URI_SCHEME = "cashu:";
    public static final String TOKEN_PREFIX = "cashu";

    public String serialize(boolean var1);

    public static class TokenUtil {
        static String serialize(@NonNull String cborToken, Version version, boolean clickable) {
            if (cborToken == null) {
                throw new NullPointerException("cborToken is marked non-null but is null");
            }
            return TokenUtil.serialize(cborToken.replaceAll("\\s+", "").getBytes(StandardCharsets.UTF_8), version, clickable);
        }

        static String serialize(byte @NonNull [] cborToken, Version version, boolean clickable) {
            if (cborToken == null) {
                throw new NullPointerException("cborToken is marked non-null but is null");
            }
            return TokenUtil.serialize(cborToken, Token.TOKEN_PREFIX, version, clickable);
        }

        static String serialize(byte @NonNull [] cborToken, @NonNull String prefix, Version version, boolean clickable) {
            if (cborToken == null) {
                throw new NullPointerException("cborToken is marked non-null but is null");
            }
            if (prefix == null) {
                throw new NullPointerException("prefix is marked non-null but is null");
            }
            String strSerializedToken = prefix + version.getCode() + Base64.getUrlEncoder().withoutPadding().encodeToString(cborToken);
            if (clickable) {
                return Token.URI_SCHEME + strSerializedToken;
            }
            return strSerializedToken;
        }
    }

    public static enum Version {
        V3(Character.valueOf('A')),
        V4(Character.valueOf('B'));

        private final Character code;

        private Version(Character code) {
            if (code == null) {
                throw new NullPointerException("code is marked non-null but is null");
            }
            this.code = code;
        }

        public Character getCode() {
            return this.code;
        }
    }
}

