/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import lombok.NonNull;
import org.bouncycastle.util.encoders.Hex;
import xyz.tcheeric.cashu.common.PublicKey;

public class CompressedPublicKey
extends PublicKey {
    CompressedPublicKey(@NonNull String s) {
        if (s == null) {
            throw new NullPointerException("s is marked non-null but is null");
        }
        this.setBytes(Hex.decode((String)s));
        if (s.length() != 66) {
            throw new IllegalArgumentException("Invalid compressed public key length (" + s.length() + ")");
        }
    }

    CompressedPublicKey(byte[] bytes) {
        this(Hex.toHexString((byte[])bytes));
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static CompressedPublicKey fromString(@NonNull String s) {
        if (s == null) {
            throw new NullPointerException("s is marked non-null but is null");
        }
        return new CompressedPublicKey(s);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static CompressedPublicKey fromBytes(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        return new CompressedPublicKey(bytes);
    }

    @Override
    public String toString() {
        return Hex.toHexString((byte[])this.getBytes());
    }

    protected static String toString(CompressedPublicKey publicKey) {
        return publicKey.toString();
    }
}

