/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.common.json.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import xyz.tcheeric.cashu.common.Signature;

public class SignatureJsonSerializer
extends JsonSerializer<Signature> {
    public void serialize(Signature value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (value == null) {
            gen.writeNull();
            return;
        }
        String hex = value.toString();
        if (hex == null) {
            gen.writeNull();
            return;
        }
        String normalized = SignatureJsonSerializer.normalizeCompressedHex(hex);
        gen.writeString(normalized);
    }

    private static String normalizeCompressedHex(String hex) {
        String h = hex.trim().toLowerCase();
        if (h.length() == 66 && (h.startsWith("02") || h.startsWith("03"))) {
            return h;
        }
        if (h.length() == 64 && h.matches("[0-9a-f]{64}")) {
            return "02" + h;
        }
        if (h.length() > 66) {
            return "02" + h.substring(h.length() - 64);
        }
        StringBuilder sb = new StringBuilder(66);
        sb.append("02");
        for (int i = h.length(); i < 64; ++i) {
            sb.append('0');
        }
        sb.append(h);
        return sb.toString();
    }
}

