/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.common;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.common.PrivateKey;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.common.json.deserializer.TagDeserializer;
import xyz.tcheeric.cashu.common.json.deserializer.WellKnownSecretDeserializer;
import xyz.tcheeric.cashu.common.json.serializer.TagSerializer;
import xyz.tcheeric.cashu.common.json.serializer.WellKnownSecretSerializer;
import xyz.tcheeric.cashu.common.util.JsonUtils;

@JsonDeserialize(using=WellKnownSecretDeserializer.class)
@JsonSerialize(using=WellKnownSecretSerializer.class)
public abstract class WellKnownSecret
implements Secret {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WellKnownSecret.class);
    private Kind kind;
    private String nonce;
    private byte[] data;
    private List<Tag> tags;

    public WellKnownSecret(@NonNull Kind kind) {
        if (kind == null) {
            throw new NullPointerException("kind is marked non-null but is null");
        }
        this.kind = kind;
        this.tags = new ArrayList<Tag>();
    }

    public WellKnownSecret(@NonNull Kind kind, byte[] data) {
        if (kind == null) {
            throw new NullPointerException("kind is marked non-null but is null");
        }
        this.kind = kind;
        this.data = data;
        this.nonce = PrivateKey.generateRandom().toString();
        this.tags = new ArrayList<Tag>();
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public void setData(@NonNull byte[] data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        this.data = data;
    }

    @Override
    public byte[] toBytes() {
        return this.data;
    }

    public void addTag(@NonNull String key, @NonNull List<Object> values) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        Tag tag = new Tag(key);
        tag.getValues().addAll(values);
        this.tags.add(tag);
    }

    public void addTag(@NonNull Tag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        this.tags.add(tag);
    }

    public void removeTag(@NonNull Tag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        this.tags.remove(tag);
    }

    public Tag getTag(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.tags.stream().filter(tag -> tag.getKey().equals(key)).findFirst().orElse(null);
    }

    public void setTag(@NonNull String key, @NonNull List<Object> values) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        Tag tag = this.getTag(key);
        if (tag == null) {
            this.addTag(key, values);
        } else {
            tag.getValues().clear();
            tag.getValues().addAll(values);
        }
    }

    public String toString() {
        return JsonUtils.JSON_MAPPER.writeValueAsString((Object)this);
    }

    @Generated
    public Kind getKind() {
        return this.kind;
    }

    @Generated
    public String getNonce() {
        return this.nonce;
    }

    @Generated
    public List<Tag> getTags() {
        return this.tags;
    }

    @Generated
    public void setKind(Kind kind) {
        this.kind = kind;
    }

    @Generated
    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    @Generated
    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WellKnownSecret)) {
            return false;
        }
        WellKnownSecret other = (WellKnownSecret)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Kind this$kind = this.getKind();
        Kind other$kind = other.getKind();
        if (this$kind == null ? other$kind != null : !((Object)((Object)this$kind)).equals((Object)other$kind)) {
            return false;
        }
        String this$nonce = this.getNonce();
        String other$nonce = other.getNonce();
        if (this$nonce == null ? other$nonce != null : !this$nonce.equals(other$nonce)) {
            return false;
        }
        if (!Arrays.equals(this.getData(), other.getData())) {
            return false;
        }
        List<Tag> this$tags = this.getTags();
        List<Tag> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WellKnownSecret;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Kind $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : ((Object)((Object)$kind)).hashCode());
        String $nonce = this.getNonce();
        result = result * 59 + ($nonce == null ? 43 : $nonce.hashCode());
        result = result * 59 + Arrays.hashCode(this.getData());
        List<Tag> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    @Generated
    public WellKnownSecret() {
    }

    public static enum Kind {
        P2PK,
        HTLC,
        VOUCHER;

    }

    @JsonDeserialize(using=TagDeserializer.class)
    @JsonSerialize(using=TagSerializer.class)
    public static class Tag {
        private String key;
        private List<Object> values;

        public Tag() {
            this.values = new ArrayList<Object>();
        }

        public Tag(@NonNull String key) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            this.key = key;
            this.values = new ArrayList<Object>();
        }

        public void addValue(@NonNull Object value) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.values.add(value);
        }

        public void removeValue(@NonNull Object value) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.values.remove(value);
        }

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public List<Object> getValues() {
            return this.values;
        }

        @Generated
        public void setKey(String key) {
            this.key = key;
        }

        @Generated
        public void setValues(List<Object> values) {
            this.values = values;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Tag)) {
                return false;
            }
            Tag other = (Tag)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            List<Object> this$values = this.getValues();
            List<Object> other$values = other.getValues();
            return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Tag;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            List<Object> $values = this.getValues();
            result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WellKnownSecret.Tag(key=" + this.getKey() + ", values=" + String.valueOf(this.getValues()) + ")";
        }
    }
}

