/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.common.json.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import lombok.Generated;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.common.P2PKSecret;
import xyz.tcheeric.cashu.common.VoucherWellKnownSecret;
import xyz.tcheeric.cashu.common.WellKnownSecret;

public class WellKnownSecretDeserializer
extends JsonDeserializer<WellKnownSecret> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WellKnownSecretDeserializer.class);

    public WellKnownSecret deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        ObjectMapper mapper = (ObjectMapper)p.getCodec();
        JsonNode node = (JsonNode)mapper.readTree(p);
        if (node.isObject()) {
            return this.deserializeObjectFormat(node);
        }
        if (!node.isArray() || node.size() < 2) {
            throw new IOException("Invalid secret format: expected array with at least 2 elements");
        }
        String kindStr = node.get(0).asText();
        WellKnownSecret.Kind kind = WellKnownSecret.Kind.valueOf(kindStr);
        JsonNode secondElement = node.get(1);
        if (secondElement.isObject()) {
            return this.deserializeLegacyFormat(kind, secondElement);
        }
        if (node.size() >= 4) {
            return this.deserializeNut10Format(kind, node);
        }
        throw new IOException("Invalid secret format: expected NUT-10 (4-element) or legacy (2-element with object)");
    }

    private WellKnownSecret deserializeObjectFormat(JsonNode objectNode) {
        JsonNode kindNode = objectNode.get("kind");
        if (kindNode == null) {
            throw new IllegalArgumentException("Missing 'kind' field in secret object");
        }
        WellKnownSecret.Kind kind = WellKnownSecret.Kind.valueOf(kindNode.asText());
        return this.deserializeLegacyFormat(kind, objectNode);
    }

    private WellKnownSecret deserializeNut10Format(WellKnownSecret.Kind kind, JsonNode node) {
        String dataHex = node.get(1).asText();
        byte[] data = Hex.decode((String)dataHex);
        String nonce = node.get(2).asText();
        WellKnownSecret secret = this.createSecret(kind);
        secret.setData(data);
        secret.setNonce(nonce);
        JsonNode tagsNode = node.get(3);
        if (tagsNode.isArray()) {
            for (JsonNode tagNode : tagsNode) {
                if (!tagNode.isArray() || tagNode.size() < 1) continue;
                String key = tagNode.get(0).asText();
                WellKnownSecret.Tag tag = new WellKnownSecret.Tag(key);
                for (int i = 1; i < tagNode.size(); ++i) {
                    JsonNode valueNode = tagNode.get(i);
                    if (valueNode.isNumber()) {
                        tag.addValue(valueNode.longValue());
                        continue;
                    }
                    tag.addValue(valueNode.asText());
                }
                if (kind == WellKnownSecret.Kind.P2PK) {
                    this.convertP2PKTagValues(tag);
                }
                secret.addTag(tag);
            }
        }
        return secret;
    }

    private WellKnownSecret deserializeLegacyFormat(WellKnownSecret.Kind kind, JsonNode objectNode) {
        JsonNode tagsNode;
        JsonNode dataNode;
        WellKnownSecret secret = this.createSecret(kind);
        JsonNode nonceNode = objectNode.get("nonce");
        if (nonceNode != null) {
            secret.setNonce(nonceNode.asText());
        }
        if ((dataNode = objectNode.get("data")) != null) {
            secret.setData(Hex.decode((String)dataNode.asText()));
        }
        if ((tagsNode = objectNode.get("tags")) != null && tagsNode.isArray()) {
            for (JsonNode tagNode : tagsNode) {
                if (!tagNode.isArray() || tagNode.size() < 1) continue;
                String key = tagNode.get(0).asText();
                WellKnownSecret.Tag tag = new WellKnownSecret.Tag(key);
                for (int i = 1; i < tagNode.size(); ++i) {
                    JsonNode valueNode = tagNode.get(i);
                    if (valueNode.isNumber()) {
                        tag.addValue(valueNode.longValue());
                        continue;
                    }
                    tag.addValue(valueNode.asText());
                }
                if (kind == WellKnownSecret.Kind.P2PK) {
                    this.convertP2PKTagValues(tag);
                }
                secret.addTag(tag);
            }
        }
        return secret;
    }

    private WellKnownSecret createSecret(WellKnownSecret.Kind kind) {
        return switch (kind) {
            case WellKnownSecret.Kind.P2PK -> new P2PKSecret();
            case WellKnownSecret.Kind.VOUCHER -> new VoucherWellKnownSecret();
            default -> throw new IllegalArgumentException("Invalid kind: " + String.valueOf((Object)kind));
        };
    }

    private void convertP2PKTagValues(WellKnownSecret.Tag tag) {
        switch (tag.getKey()) {
            case "sigflag": {
                ArrayList<Object> values = new ArrayList<Object>();
                for (Object v : tag.getValues()) {
                    if (v instanceof String) {
                        String s = (String)v;
                        values.add((Object)P2PKSecret.SignatureFlag.valueOf(s));
                        continue;
                    }
                    values.add(v);
                }
                tag.setValues(values);
                break;
            }
            case "n_sigs": 
            case "locktime": {
                ArrayList<Object> values = new ArrayList<Object>();
                for (Object v : tag.getValues()) {
                    if (v instanceof Number) {
                        Number n = (Number)v;
                        values.add(n.intValue());
                        continue;
                    }
                    values.add(v);
                }
                tag.setValues(values);
                break;
            }
            case "pubkeys": 
            case "refund": {
                ArrayList<Object> values = new ArrayList<Object>();
                for (Object v : tag.getValues()) {
                    values.add(String.valueOf(v));
                }
                tag.setValues(values);
            }
        }
    }
}

