/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.common.json.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.bouncycastle.util.encoders.Hex;
import xyz.tcheeric.cashu.common.WellKnownSecret;

public class WellKnownSecretSerializer
extends JsonSerializer<WellKnownSecret> {
    public void serialize(WellKnownSecret value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartArray();
        gen.writeString(value.getKind().name());
        gen.writeString(Hex.toHexString((byte[])value.getData()));
        gen.writeString(value.getNonce());
        gen.writeStartArray();
        if (value.getTags() != null) {
            for (WellKnownSecret.Tag tag : value.getTags()) {
                gen.writeStartArray();
                gen.writeString(tag.getKey());
                if (tag.getValues() != null) {
                    for (Object v : tag.getValues()) {
                        if (v instanceof Number) {
                            gen.writeNumber(((Number)v).longValue());
                            continue;
                        }
                        gen.writeString(String.valueOf(v));
                    }
                }
                gen.writeEndArray();
            }
        }
        gen.writeEndArray();
        gen.writeEndArray();
    }
}

