/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.bitcoinj.crypto.DeterministicKey;
import xyz.tcheeric.bips.bip32.nut.Nut13Derivation;
import xyz.tcheeric.cashu.common.DeterministicSecret;
import xyz.tcheeric.cashu.common.KeysetId;
import xyz.tcheeric.cashu.common.P2PKSecret;
import xyz.tcheeric.cashu.common.RandomStringSecret;
import xyz.tcheeric.cashu.common.Secret;

public class SecretFactory<T extends Secret> {
    private byte[] p2pkPublicKey;

    public T create() {
        if (this.p2pkPublicKey == null) {
            return (T)RandomStringSecret.create();
        }
        return (T)new P2PKSecret(this.p2pkPublicKey);
    }

    public static <T extends Secret> T create(byte[] p2pkPublicKey) {
        return new SecretFactory<T>(p2pkPublicKey).create();
    }

    public static DeterministicSecret createDeterministic(@NonNull DeterministicKey masterKey, @NonNull KeysetId keysetId, int counter) {
        if (masterKey == null) {
            throw new NullPointerException("masterKey is marked non-null but is null");
        }
        if (keysetId == null) {
            throw new NullPointerException("keysetId is marked non-null but is null");
        }
        byte[] secretBytes = Nut13Derivation.deriveSecret((DeterministicKey)masterKey, (String)keysetId.toString(), (int)counter);
        return DeterministicSecret.create(secretBytes, keysetId, counter);
    }

    public static List<DeterministicSecret> createDeterministicBatch(@NonNull DeterministicKey masterKey, @NonNull KeysetId keysetId, int startCounter, int count) {
        if (masterKey == null) {
            throw new NullPointerException("masterKey is marked non-null but is null");
        }
        if (keysetId == null) {
            throw new NullPointerException("keysetId is marked non-null but is null");
        }
        if (count < 0) {
            throw new IllegalArgumentException("Count must be non-negative, got: " + count);
        }
        ArrayList<DeterministicSecret> secrets = new ArrayList<DeterministicSecret>(count);
        for (int i = 0; i < count; ++i) {
            secrets.add(SecretFactory.createDeterministic(masterKey, keysetId, startCounter + i));
        }
        return secrets;
    }

    public static DeterministicSecret createDeterministicFromMnemonic(@NonNull String mnemonic, @NonNull String passphrase, @NonNull KeysetId keysetId, int counter) {
        if (mnemonic == null) {
            throw new NullPointerException("mnemonic is marked non-null but is null");
        }
        if (passphrase == null) {
            throw new NullPointerException("passphrase is marked non-null but is null");
        }
        if (keysetId == null) {
            throw new NullPointerException("keysetId is marked non-null but is null");
        }
        Nut13Derivation.Nut13DerivationParams params = Nut13Derivation.Nut13DerivationParams.builder().mnemonicPhrase(mnemonic).passphrase(passphrase).keysetIdHex(keysetId.toString()).counter(counter).build();
        byte[] secretBytes = Nut13Derivation.deriveSecretFromMnemonic((Nut13Derivation.Nut13DerivationParams)params);
        return DeterministicSecret.create(secretBytes, keysetId, counter);
    }

    public static SecretAndBlindingFactor createDeterministicWithBlindingFactor(@NonNull DeterministicKey masterKey, @NonNull KeysetId keysetId, int counter) {
        if (masterKey == null) {
            throw new NullPointerException("masterKey is marked non-null but is null");
        }
        if (keysetId == null) {
            throw new NullPointerException("keysetId is marked non-null but is null");
        }
        Nut13Derivation.SecretAndBlindingFactor pair = Nut13Derivation.deriveSecretAndBlindingFactor((DeterministicKey)masterKey, (String)keysetId.toString(), (int)counter);
        DeterministicSecret secret = DeterministicSecret.create(pair.secret(), keysetId, counter);
        return new SecretAndBlindingFactor(secret, pair.blindingFactor());
    }

    @Generated
    public byte[] getP2pkPublicKey() {
        return this.p2pkPublicKey;
    }

    @Generated
    public void setP2pkPublicKey(byte[] p2pkPublicKey) {
        this.p2pkPublicKey = p2pkPublicKey;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SecretFactory)) {
            return false;
        }
        SecretFactory other = (SecretFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.equals(this.getP2pkPublicKey(), other.getP2pkPublicKey());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SecretFactory;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getP2pkPublicKey());
        return result;
    }

    @Generated
    public String toString() {
        return "SecretFactory(p2pkPublicKey=" + Arrays.toString(this.getP2pkPublicKey()) + ")";
    }

    @Generated
    public SecretFactory() {
    }

    @Generated
    public SecretFactory(byte[] p2pkPublicKey) {
        this.p2pkPublicKey = p2pkPublicKey;
    }

    public record SecretAndBlindingFactor(DeterministicSecret secret, byte[] blindingFactor) {
        public int getCounter() {
            return this.secret.getCounter();
        }

        public KeysetId getKeysetId() {
            return this.secret.getKeysetId();
        }
    }
}

