/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.common.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.common.PublicKey;
import xyz.tcheeric.cashu.common.RandomStringSecret;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.common.WellKnownSecret;
import xyz.tcheeric.cashu.common.util.JsonUtils;
import xyz.tcheeric.cashu.crypto.BDHKEUtils;

public final class SecretUtil<T extends Secret> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecretUtil.class);
    private static final ObjectMapper MAPPER = JsonUtils.JSON_MAPPER;

    public static <T extends Secret> T toSecret(@NonNull Object value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (value instanceof Secret) {
            Secret secret = (Secret)value;
            return (T)secret;
        }
        if (value instanceof String) {
            String str = (String)value;
            String trimmed = str.trim();
            if (trimmed.startsWith("[") && trimmed.endsWith("]")) {
                try {
                    List list = (List)MAPPER.readValue(trimmed, new TypeReference<List<?>>(){});
                    return SecretUtil.listToSecret(list);
                }
                catch (Exception e) {
                    log.debug("secret_util to_secret json_parse_failed secret_preview={} error={}", trimmed.length() > 40 ? trimmed.substring(0, 40) + "..." : trimmed, (Object)e.getMessage());
                }
            }
            return (T)RandomStringSecret.fromString(str);
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return SecretUtil.mapToSecret(map);
        }
        if (value instanceof List) {
            List list = (List)value;
            return SecretUtil.listToSecret(list);
        }
        throw new IllegalArgumentException("Unknown secret type");
    }

    public static <T extends Secret> String toY(@NonNull T secret) {
        if (secret == null) {
            throw new NullPointerException("secret is marked non-null but is null");
        }
        byte[] secretStringBytes = secret.toString().getBytes(StandardCharsets.UTF_8);
        return PublicKey.fromPoint(BDHKEUtils.hashToCurve((byte[])secretStringBytes), true).toString();
    }

    public static String toYFromString(@NonNull String secretString) {
        if (secretString == null) {
            throw new NullPointerException("secretString is marked non-null but is null");
        }
        byte[] secretStringBytes = secretString.getBytes(StandardCharsets.UTF_8);
        return PublicKey.fromPoint(BDHKEUtils.hashToCurve((byte[])secretStringBytes), true).toString();
    }

    private static <T extends Secret> T listToSecret(List<?> list) {
        Object second;
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Empty list cannot be converted to secret");
        }
        String kind = String.valueOf(list.get(0));
        Object v0 = second = list.size() > 1 ? list.get(1) : null;
        if (second instanceof Map) {
            Map data = second;
            HashMap<String, String> map = new HashMap<String, String>();
            data.forEach((k, v) -> map.put(String.valueOf(k), (String)v));
            map.put("kind", kind);
            return (T)((Secret)MAPPER.convertValue(map, WellKnownSecret.class));
        }
        String hexData = second != null ? String.valueOf(second) : "";
        String nonce = list.size() > 2 ? String.valueOf(list.get(2)) : "";
        List tags = list.size() > 3 && list.get(3) instanceof List ? (List)list.get(3) : List.of();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("kind", kind);
        map.put("nonce", nonce);
        try {
            byte[] data = Hex.decode((String)hexData);
            map.put("data", data);
        }
        catch (Exception e) {
            log.warn("secret_util list_to_secret hex_decode_failed kind={} error={}", (Object)kind, (Object)e.getMessage());
            map.put("data", new byte[0]);
        }
        map.put("tags", tags);
        return (T)((Secret)MAPPER.convertValue(map, WellKnownSecret.class));
    }

    private static <T extends Secret> T mapToSecret(Map<?, ?> src) {
        HashMap map = new HashMap();
        src.forEach((k, v) -> map.put(String.valueOf(k), v));
        if (!map.containsKey("kind")) {
            throw new IllegalArgumentException("Unknown secret type");
        }
        return (T)((Secret)MAPPER.convertValue(map, WellKnownSecret.class));
    }
}

