/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public final class SplittingService {
    public List<Integer> split(long amount, Collection<Integer> availableDenominations) {
        Integer next;
        if (amount < 0L) {
            throw new IllegalArgumentException("Amount must be non-negative");
        }
        if (amount == 0L) {
            return List.of();
        }
        Set positiveDenoms = availableDenominations.stream().filter(value -> value != null && value > 0).collect(Collectors.toSet());
        if (positiveDenoms.isEmpty()) {
            throw new IllegalStateException("No positive denominations available");
        }
        List sorted = positiveDenoms.stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
        ArrayList<Integer> parts = new ArrayList<Integer>();
        for (long remaining = amount; remaining > 0L; remaining -= (long)next.intValue()) {
            next = null;
            Iterator iterator = sorted.iterator();
            while (iterator.hasNext()) {
                int denom = (Integer)iterator.next();
                if ((long)denom > remaining) continue;
                next = denom;
                break;
            }
            if (next == null) {
                throw new IllegalStateException("Cannot represent amount " + amount + " with denominations " + String.valueOf(sorted));
            }
            parts.add(next);
        }
        return parts;
    }
}

