/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.entities.rest;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import xyz.tcheeric.cashu.common.BlindedMessage;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.crypto.util.Utils;

public class PostMintRequest<T extends Secret> {
    @JsonProperty(value="quote")
    private String quoteId;
    @JsonProperty(value="outputs")
    private List<BlindedMessage> blindedMessages;
    @JsonIgnore
    private List<T> secrets;
    @JsonIgnore
    private List<byte[]> blindingFactors;

    public PostMintRequest() {
        this.blindedMessages = new ArrayList<BlindedMessage>();
        this.secrets = new ArrayList<T>();
        this.blindingFactors = new ArrayList<byte[]>();
    }

    public String toString() {
        ArrayList bfactors = new ArrayList();
        this.blindingFactors.stream().map(Utils::bytesToHexString).forEach(bfactors::add);
        return "PostMintRequest{quoteId='" + this.quoteId + "', blindedMessages=" + String.valueOf(this.blindedMessages) + ", secrets=" + String.valueOf(this.secrets) + ", blindingFactors=" + String.valueOf(bfactors) + "}";
    }

    public void addSecret(@NonNull T secret, int index) {
        if (secret == null) {
            throw new NullPointerException("secret is marked non-null but is null");
        }
        this.secrets.add(index, secret);
    }

    public void addBlindingFactor(byte[] blindingFactor, int index) {
        this.blindingFactors.add(index, blindingFactor);
    }

    public void addBlindMessage(@NonNull BlindedMessage blindedMessage, int index) {
        if (blindedMessage == null) {
            throw new NullPointerException("blindedMessage is marked non-null but is null");
        }
        this.blindedMessages.add(index, blindedMessage);
    }

    public T getSecret(int index) {
        return (T)((Secret)this.secrets.get(index));
    }

    public byte[] getBlindingFactor(int index) {
        return this.blindingFactors.get(index);
    }

    @Generated
    public PostMintRequest(String quoteId, List<BlindedMessage> blindedMessages, List<T> secrets, List<byte[]> blindingFactors) {
        this.quoteId = quoteId;
        this.blindedMessages = blindedMessages;
        this.secrets = secrets;
        this.blindingFactors = blindingFactors;
    }

    @Generated
    public String getQuoteId() {
        return this.quoteId;
    }

    @Generated
    public List<BlindedMessage> getBlindedMessages() {
        return this.blindedMessages;
    }

    @Generated
    public List<T> getSecrets() {
        return this.secrets;
    }

    @Generated
    public List<byte[]> getBlindingFactors() {
        return this.blindingFactors;
    }

    @JsonProperty(value="quote")
    @Generated
    public void setQuoteId(String quoteId) {
        this.quoteId = quoteId;
    }

    @JsonProperty(value="outputs")
    @Generated
    public void setBlindedMessages(List<BlindedMessage> blindedMessages) {
        this.blindedMessages = blindedMessages;
    }

    @JsonIgnore
    @Generated
    public void setSecrets(List<T> secrets) {
        this.secrets = secrets;
    }

    @JsonIgnore
    @Generated
    public void setBlindingFactors(List<byte[]> blindingFactors) {
        this.blindingFactors = blindingFactors;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PostMintRequest)) {
            return false;
        }
        PostMintRequest other = (PostMintRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$quoteId = this.getQuoteId();
        String other$quoteId = other.getQuoteId();
        if (this$quoteId == null ? other$quoteId != null : !this$quoteId.equals(other$quoteId)) {
            return false;
        }
        List<BlindedMessage> this$blindedMessages = this.getBlindedMessages();
        List<BlindedMessage> other$blindedMessages = other.getBlindedMessages();
        if (this$blindedMessages == null ? other$blindedMessages != null : !((Object)this$blindedMessages).equals(other$blindedMessages)) {
            return false;
        }
        List<T> this$secrets = this.getSecrets();
        List<T> other$secrets = other.getSecrets();
        if (this$secrets == null ? other$secrets != null : !((Object)this$secrets).equals(other$secrets)) {
            return false;
        }
        List<byte[]> this$blindingFactors = this.getBlindingFactors();
        List<byte[]> other$blindingFactors = other.getBlindingFactors();
        return !(this$blindingFactors == null ? other$blindingFactors != null : !((Object)this$blindingFactors).equals(other$blindingFactors));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PostMintRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $quoteId = this.getQuoteId();
        result = result * 59 + ($quoteId == null ? 43 : $quoteId.hashCode());
        List<BlindedMessage> $blindedMessages = this.getBlindedMessages();
        result = result * 59 + ($blindedMessages == null ? 43 : ((Object)$blindedMessages).hashCode());
        List<T> $secrets = this.getSecrets();
        result = result * 59 + ($secrets == null ? 43 : ((Object)$secrets).hashCode());
        List<byte[]> $blindingFactors = this.getBlindingFactors();
        result = result * 59 + ($blindingFactors == null ? 43 : ((Object)$blindingFactors).hashCode());
        return result;
    }
}

