/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.entities.rest;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import xyz.tcheeric.cashu.common.KeySet;
import xyz.tcheeric.cashu.common.Proof;
import xyz.tcheeric.cashu.common.Secret;

public abstract class PostInputRequest<T extends Secret> {
    @JsonProperty(value="inputs")
    private List<Proof<T>> inputs;

    public int getFees(@NonNull KeySet keySet) {
        if (keySet == null) {
            throw new NullPointerException("keySet is marked non-null but is null");
        }
        int sum_fees = 0;
        for (Proof<T> proof : this.inputs) {
            String keysetId = proof.getKeySetId();
            assert (keysetId.equals(keySet.getId())) : "Keyset and proof keyset id do not match";
            sum_fees += keySet.getPartPerThousand();
        }
        return Math.floorDiv(sum_fees + 999, 1000);
    }

    @Generated
    public PostInputRequest(List<Proof<T>> inputs) {
        this.inputs = inputs;
    }

    @Generated
    public PostInputRequest() {
    }

    @Generated
    public List<Proof<T>> getInputs() {
        return this.inputs;
    }

    @Generated
    public void setInputs(List<Proof<T>> inputs) {
        this.inputs = inputs;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PostInputRequest)) {
            return false;
        }
        PostInputRequest other = (PostInputRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Proof<T>> this$inputs = this.getInputs();
        List<Proof<T>> other$inputs = other.getInputs();
        return !(this$inputs == null ? other$inputs != null : !((Object)this$inputs).equals(other$inputs));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PostInputRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Proof<T>> $inputs = this.getInputs();
        result = result * 59 + ($inputs == null ? 43 : ((Object)$inputs).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PostInputRequest(inputs=" + String.valueOf(this.getInputs()) + ")";
    }
}

