/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.adapter.out.jdbc;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.sql.DataSource;
import xyz.tcheeric.cashu.mint.admin.adapter.out.jdbc.JdbcRepositoryException;
import xyz.tcheeric.cashu.mint.admin.application.port.out.OutboxRepository;
import xyz.tcheeric.cashu.mint.admin.domain.MintId;
import xyz.tcheeric.cashu.mint.admin.domain.OutboxMessage;

public class JdbcOutboxRepository
implements OutboxRepository {
    private static final String INSERT_SQL = "    INSERT INTO admin_outbox (event_id, aggregate_id, aggregate_type, event_type, payload, attributes, occurred_at,\n                              available_at, last_attempt_at, dispatched_at, delivery_attempts)\n    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\n";
    private static final String SELECT_PENDING_SQL = "    SELECT event_id, aggregate_id, aggregate_type, event_type, payload, attributes, occurred_at, available_at,\n           last_attempt_at, dispatched_at, delivery_attempts\n    FROM admin_outbox\n    WHERE dispatched_at IS NULL AND available_at <= ?\n    ORDER BY available_at, event_id\n    LIMIT ?\n";
    private static final String MARK_DISPATCHED_SQL = "    UPDATE admin_outbox\n    SET dispatched_at = ?, last_attempt_at = ?\n    WHERE event_id = ?\n";
    private static final String RECORD_FAILURE_SQL = "    UPDATE admin_outbox\n    SET delivery_attempts = delivery_attempts + 1,\n        last_attempt_at = ?,\n        available_at = ?\n    WHERE event_id = ?\n";
    private static final TypeReference<Map<String, String>> MAP_TYPE = new TypeReference<Map<String, String>>(){};
    private final DataSource dataSource;
    private final ObjectMapper objectMapper;

    public JdbcOutboxRepository(DataSource dataSource, ObjectMapper objectMapper) {
        this.dataSource = dataSource;
        this.objectMapper = objectMapper;
    }

    @Override
    public void append(OutboxMessage message) {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(INSERT_SQL);){
            statement.setObject(1, message.eventId());
            statement.setObject(2, message.aggregateId().value());
            statement.setString(3, message.aggregateType());
            statement.setString(4, message.eventType());
            statement.setString(5, message.payload());
            statement.setString(6, this.objectMapper.writeValueAsString(message.attributes()));
            statement.setTimestamp(7, Timestamp.from(message.occurredAt()));
            statement.setTimestamp(8, Timestamp.from(message.availableAt()));
            statement.setTimestamp(9, this.toTimestamp(message.lastAttemptAt()));
            statement.setTimestamp(10, this.toTimestamp(message.dispatchedAt()));
            statement.setInt(11, message.deliveryAttempts());
            statement.executeUpdate();
        }
        catch (IOException | SQLException ex) {
            throw new JdbcRepositoryException("Failed to append outbox message", ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<OutboxMessage> findPending(Instant availableBefore, int limit) {
        try (Connection connection = this.dataSource.getConnection();){
            List<OutboxMessage> list;
            block22: {
                PreparedStatement statement = connection.prepareStatement(SELECT_PENDING_SQL);
                try {
                    statement.setTimestamp(1, Timestamp.from(availableBefore));
                    statement.setInt(2, limit);
                    ArrayList<OutboxMessage> messages = new ArrayList<OutboxMessage>();
                    try (ResultSet resultSet = statement.executeQuery();){
                        while (resultSet.next()) {
                            messages.add(this.mapRow(resultSet));
                        }
                    }
                    list = List.copyOf(messages);
                    if (statement == null) break block22;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return list;
        }
        catch (IOException | SQLException ex) {
            throw new JdbcRepositoryException("Failed to load pending outbox messages", ex);
        }
    }

    @Override
    public void markDispatched(UUID eventId, Instant dispatchedAt) {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(MARK_DISPATCHED_SQL);){
            Timestamp timestamp = Timestamp.from(dispatchedAt);
            statement.setTimestamp(1, timestamp);
            statement.setTimestamp(2, timestamp);
            statement.setObject(3, eventId);
            if (statement.executeUpdate() == 0) {
                throw new JdbcRepositoryException("Outbox message " + String.valueOf(eventId) + " not found");
            }
        }
        catch (SQLException ex) {
            throw new JdbcRepositoryException("Failed to mark outbox message dispatched", ex);
        }
    }

    @Override
    public void recordFailure(UUID eventId, Instant attemptAt, Instant nextAttemptAt) {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(RECORD_FAILURE_SQL);){
            statement.setTimestamp(1, Timestamp.from(attemptAt));
            statement.setTimestamp(2, Timestamp.from(nextAttemptAt));
            statement.setObject(3, eventId);
            if (statement.executeUpdate() == 0) {
                throw new JdbcRepositoryException("Outbox message " + String.valueOf(eventId) + " not found");
            }
        }
        catch (SQLException ex) {
            throw new JdbcRepositoryException("Failed to record outbox failure", ex);
        }
    }

    private OutboxMessage mapRow(ResultSet resultSet) throws SQLException, IOException {
        UUID eventId = this.getUuid(resultSet, "event_id");
        MintId aggregateId = MintId.of(this.getUuid(resultSet, "aggregate_id"));
        Map<String, String> attributes = this.objectMapper.readValue(resultSet.getString("attributes"), MAP_TYPE);
        return new OutboxMessage(eventId, aggregateId, resultSet.getString("aggregate_type"), resultSet.getString("event_type"), resultSet.getString("payload"), attributes, this.getInstant(resultSet, "occurred_at"), this.getInstant(resultSet, "available_at"), this.getInstant(resultSet, "last_attempt_at"), this.getInstant(resultSet, "dispatched_at"), resultSet.getInt("delivery_attempts"));
    }

    private Instant getInstant(ResultSet resultSet, String column) throws SQLException {
        Timestamp timestamp = resultSet.getTimestamp(column);
        if (timestamp == null) {
            return null;
        }
        return timestamp.toInstant();
    }

    private Timestamp toTimestamp(Instant instant) {
        if (instant == null) {
            return null;
        }
        return Timestamp.from(instant);
    }

    private UUID getUuid(ResultSet resultSet, String column) throws SQLException {
        Object value = resultSet.getObject(column);
        if (value instanceof UUID) {
            UUID uuid = (UUID)value;
            return uuid;
        }
        return UUID.fromString(resultSet.getString(column));
    }
}

