/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.adapter.persistence;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import xyz.tcheeric.cashu.mint.admin.adapter.persistence.MintAggregateRowMapper;
import xyz.tcheeric.cashu.mint.admin.adapter.persistence.MintRepository;
import xyz.tcheeric.cashu.mint.admin.adapter.persistence.TransactionExecutor;
import xyz.tcheeric.cashu.mint.admin.domain.MintAggregate;
import xyz.tcheeric.cashu.mint.admin.domain.MintId;

public final class RelationalMintRepository
implements MintRepository {
    private final MintAggregateRowMapper rowMapper;
    private final TransactionExecutor transactionExecutor;

    public RelationalMintRepository(MintAggregateRowMapper rowMapper, TransactionExecutor transactionExecutor) {
        this.rowMapper = Objects.requireNonNull(rowMapper, "row mapper must not be null");
        this.transactionExecutor = Objects.requireNonNull(transactionExecutor, "transaction executor must not be null");
    }

    @Override
    public Optional<MintAggregate> findById(MintId mintId) {
        Objects.requireNonNull(mintId, "mint identifier must not be null");
        return this.transactionExecutor.execute(() -> Optional.empty());
    }

    @Override
    public List<MintAggregate> findAll() {
        return this.transactionExecutor.execute(() -> List.of());
    }

    @Override
    public MintAggregate save(MintAggregate aggregate) {
        Objects.requireNonNull(aggregate, "mint aggregate must not be null");
        return this.transactionExecutor.execute(() -> {
            this.rowMapper.toRow(aggregate);
            return aggregate;
        });
    }

    @Override
    public void delete(MintId mintId) {
        Objects.requireNonNull(mintId, "mint identifier must not be null");
        this.transactionExecutor.executeVoid(() -> {});
    }
}

