/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.application.port.out;

import java.util.Objects;
import xyz.tcheeric.cashu.mint.admin.domain.AuditMetadata;
import xyz.tcheeric.cashu.mint.admin.domain.ConfigurationRevisionId;
import xyz.tcheeric.cashu.mint.admin.domain.LifecycleState;
import xyz.tcheeric.cashu.mint.admin.domain.MintId;

public record MintLifecycleEvent(MintLifecycleEventType type, MintId mintId, LifecycleState.State previousState, LifecycleState.State currentState, ConfigurationRevisionId configurationRevisionId, String versionTag, AuditMetadata auditMetadata) {
    public MintLifecycleEvent {
        Objects.requireNonNull(type, "event type must not be null");
        Objects.requireNonNull(mintId, "mint id must not be null");
        Objects.requireNonNull(currentState, "current state must not be null");
        Objects.requireNonNull(configurationRevisionId, "configuration revision must not be null");
        if (versionTag == null || versionTag.isBlank()) {
            throw new IllegalArgumentException("version tag must not be blank");
        }
        Objects.requireNonNull(auditMetadata, "audit metadata must not be null");
    }

    public static MintLifecycleEvent created(MintId mintId, LifecycleState.State currentState, ConfigurationRevisionId revisionId, String versionTag, AuditMetadata auditMetadata) {
        return new MintLifecycleEvent(MintLifecycleEventType.CREATED, mintId, null, currentState, revisionId, versionTag, auditMetadata);
    }

    public static MintLifecycleEvent configurationUpdated(MintId mintId, LifecycleState.State currentState, ConfigurationRevisionId revisionId, String versionTag, AuditMetadata auditMetadata) {
        return new MintLifecycleEvent(MintLifecycleEventType.CONFIGURATION_UPDATED, mintId, currentState, currentState, revisionId, versionTag, auditMetadata);
    }

    public static MintLifecycleEvent paused(MintId mintId, LifecycleState.State previousState, LifecycleState.State currentState, ConfigurationRevisionId revisionId, String versionTag, AuditMetadata auditMetadata) {
        return new MintLifecycleEvent(MintLifecycleEventType.PAUSED, mintId, previousState, currentState, revisionId, versionTag, auditMetadata);
    }

    public static MintLifecycleEvent resumed(MintId mintId, LifecycleState.State previousState, LifecycleState.State currentState, ConfigurationRevisionId revisionId, String versionTag, AuditMetadata auditMetadata) {
        return new MintLifecycleEvent(MintLifecycleEventType.RESUMED, mintId, previousState, currentState, revisionId, versionTag, auditMetadata);
    }

    public static MintLifecycleEvent retired(MintId mintId, LifecycleState.State previousState, LifecycleState.State currentState, ConfigurationRevisionId revisionId, String versionTag, AuditMetadata auditMetadata) {
        return new MintLifecycleEvent(MintLifecycleEventType.RETIRED, mintId, previousState, currentState, revisionId, versionTag, auditMetadata);
    }

    public static enum MintLifecycleEventType {
        CREATED,
        CONFIGURATION_UPDATED,
        PAUSED,
        RESUMED,
        RETIRED;

    }
}

