/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.cli.command;

import java.util.Objects;
import java.util.concurrent.Callable;
import picocli.CommandLine;
import xyz.tcheeric.cashu.mint.admin.cli.command.CommandIOOptions;
import xyz.tcheeric.cashu.mint.admin.cli.io.CommandPayloadMapper;
import xyz.tcheeric.cashu.mint.admin.cli.io.ResponseRenderingService;
import xyz.tcheeric.cashu.mint.admin.cli.model.MintStatusRequest;
import xyz.tcheeric.cashu.mint.admin.cli.model.MintStatusResponse;
import xyz.tcheeric.cashu.mint.admin.cli.port.MintStatusPort;

@CommandLine.Command(name="mint", description={"Inspect the state of a mint"}, mixinStandardHelpOptions=true)
public final class MintCommand
implements Callable<Integer> {
    private final MintStatusPort statusPort;
    private final CommandPayloadMapper payloadMapper;
    private final ResponseRenderingService renderingService;
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;
    @CommandLine.Mixin
    private final CommandIOOptions ioOptions = new CommandIOOptions();

    public MintCommand(MintStatusPort statusPort, CommandPayloadMapper payloadMapper, ResponseRenderingService renderingService) {
        this.statusPort = Objects.requireNonNull(statusPort, "statusPort");
        this.payloadMapper = Objects.requireNonNull(payloadMapper, "payloadMapper");
        this.renderingService = Objects.requireNonNull(renderingService, "renderingService");
    }

    @Override
    public Integer call() {
        MintStatusRequest request = this.ioOptions.readPayload(this.payloadMapper, MintStatusRequest.class).orElseGet(MintStatusRequest::defaultRequest);
        MintStatusResponse response = this.statusPort.fetchStatus(request);
        this.spec.commandLine().getOut().println(this.renderingService.render(response, this.ioOptions.outputFormat()));
        return 0;
    }
}

