/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.cli.command;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import picocli.CommandLine;
import xyz.tcheeric.cashu.mint.admin.cli.command.CommandIOOptions;
import xyz.tcheeric.cashu.mint.admin.cli.io.CommandPayloadMapper;
import xyz.tcheeric.cashu.mint.admin.cli.io.ResponseRenderingService;
import xyz.tcheeric.cashu.mint.admin.cli.model.MintUserRecord;
import xyz.tcheeric.cashu.mint.admin.cli.model.MintUsersRequest;
import xyz.tcheeric.cashu.mint.admin.cli.port.MintUsersPort;

@CommandLine.Command(name="users", description={"Inspect operator accounts"}, mixinStandardHelpOptions=true)
public final class MintUsersCommand
implements Callable<Integer> {
    private final MintUsersPort usersPort;
    private final CommandPayloadMapper payloadMapper;
    private final ResponseRenderingService renderingService;
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;
    @CommandLine.Option(names={"-m", "--mint-id"}, description={"Mint identifier when no payload is supplied."}, defaultValue="default-mint")
    private String mintId = "default-mint";
    @CommandLine.Option(names={"--include-inactive"}, description={"Include inactive operators when no payload is supplied."}, defaultValue="false")
    private boolean includeInactive;
    @CommandLine.Mixin
    private final CommandIOOptions ioOptions = new CommandIOOptions();

    public MintUsersCommand(MintUsersPort usersPort, CommandPayloadMapper payloadMapper, ResponseRenderingService renderingService) {
        this.usersPort = Objects.requireNonNull(usersPort, "usersPort");
        this.payloadMapper = Objects.requireNonNull(payloadMapper, "payloadMapper");
        this.renderingService = Objects.requireNonNull(renderingService, "renderingService");
    }

    @Override
    public Integer call() {
        MintUsersRequest request = this.ioOptions.readPayload(this.payloadMapper, MintUsersRequest.class).orElseGet(() -> new MintUsersRequest(this.mintId, this.includeInactive));
        List<MintUserRecord> users = this.usersPort.listUsers(request);
        this.spec.commandLine().getOut().println(this.renderingService.render(users, this.ioOptions.outputFormat()));
        return 0;
    }
}

