/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.domain;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import xyz.tcheeric.cashu.mint.admin.domain.AuditMetadata;
import xyz.tcheeric.cashu.mint.admin.domain.ConfigurationRevisionId;

public final class ConfigurationSet {
    private final ConfigurationRevisionId revisionId;
    private final Map<String, String> parameters;
    private final AuditMetadata auditMetadata;

    public ConfigurationSet(ConfigurationRevisionId revisionId, Map<String, String> parameters, AuditMetadata auditMetadata) {
        this.revisionId = Objects.requireNonNull(revisionId, "revision id must not be null");
        this.parameters = Map.copyOf(this.validateParameters(parameters));
        this.auditMetadata = Objects.requireNonNull(auditMetadata, "audit metadata must not be null");
    }

    private Map<String, String> validateParameters(Map<String, String> parameters) {
        Objects.requireNonNull(parameters, "parameters must not be null");
        LinkedHashMap<String, String> copy = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String key = ConfigurationSet.requireNonBlank(entry.getKey(), "parameter key");
            String value = ConfigurationSet.requireNonBlank(entry.getValue(), "parameter value");
            copy.put(key, value);
        }
        return copy;
    }

    private static String requireNonBlank(String value, String fieldName) {
        if (value == null || value.isBlank()) {
            throw new IllegalArgumentException(fieldName + " must not be blank");
        }
        return value;
    }

    public ConfigurationSet updateParameter(String key, String value, ConfigurationRevisionId nextRevision, AuditMetadata metadata) {
        ConfigurationRevisionId revision = Objects.requireNonNull(nextRevision, "next revision must not be null");
        if (!revision.isAfter(this.revisionId)) {
            throw new IllegalArgumentException("next revision must be greater than current revision");
        }
        LinkedHashMap<String, String> updated = new LinkedHashMap<String, String>(this.parameters);
        updated.put(ConfigurationSet.requireNonBlank(key, "parameter key"), ConfigurationSet.requireNonBlank(value, "parameter value"));
        return new ConfigurationSet(revision, updated, Objects.requireNonNull(metadata, "audit metadata must not be null"));
    }

    @Generated
    public ConfigurationRevisionId revisionId() {
        return this.revisionId;
    }

    @Generated
    public Map<String, String> parameters() {
        return this.parameters;
    }

    @Generated
    public AuditMetadata auditMetadata() {
        return this.auditMetadata;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigurationSet)) {
            return false;
        }
        ConfigurationSet other = (ConfigurationSet)o;
        ConfigurationRevisionId this$revisionId = this.revisionId();
        ConfigurationRevisionId other$revisionId = other.revisionId();
        if (this$revisionId == null ? other$revisionId != null : !((Object)this$revisionId).equals(other$revisionId)) {
            return false;
        }
        Map<String, String> this$parameters = this.parameters();
        Map<String, String> other$parameters = other.parameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        AuditMetadata this$auditMetadata = this.auditMetadata();
        AuditMetadata other$auditMetadata = other.auditMetadata();
        return !(this$auditMetadata == null ? other$auditMetadata != null : !((Object)this$auditMetadata).equals(other$auditMetadata));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConfigurationRevisionId $revisionId = this.revisionId();
        result = result * 59 + ($revisionId == null ? 43 : ((Object)$revisionId).hashCode());
        Map<String, String> $parameters = this.parameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        AuditMetadata $auditMetadata = this.auditMetadata();
        result = result * 59 + ($auditMetadata == null ? 43 : ((Object)$auditMetadata).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ConfigurationSet(revisionId=" + String.valueOf(this.revisionId()) + ", parameters=" + String.valueOf(this.parameters()) + ", auditMetadata=" + String.valueOf(this.auditMetadata()) + ")";
    }
}

