/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.domain;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

public final class LifecycleState {
    private final State value;

    private LifecycleState(State value) {
        this.value = Objects.requireNonNull(value, "lifecycle state must not be null");
    }

    public static LifecycleState of(State value) {
        return new LifecycleState(Objects.requireNonNull(value, "lifecycle state must not be null"));
    }

    public static LifecycleState provisioned() {
        return new LifecycleState(State.PROVISIONED);
    }

    public boolean canTransitionTo(State target) {
        return this.approvalRequirementsFor(target).isPresent();
    }

    public Optional<TransitionApproval> approvalRequirementsFor(State target) {
        Objects.requireNonNull(target, "target state must not be null");
        if (this.value == target) {
            return Optional.of(TransitionApproval.noChange(target));
        }
        return this.value.findApprovalFor(target);
    }

    public TransitionApproval guardTransitionTo(State target) {
        return this.approvalRequirementsFor(target).orElseThrow(() -> new IllegalStateException(this.buildDisallowedTransitionMessage(target)));
    }

    public LifecycleState transitionTo(State target) {
        this.guardTransitionTo(target);
        if (this.value == target) {
            return this;
        }
        return new LifecycleState(target);
    }

    public Map<State, TransitionApproval> allowedTransitions() {
        return this.value.transitionApprovals();
    }

    private String buildDisallowedTransitionMessage(State target) {
        String allowedDescriptions = this.value.transitionApprovals().values().stream().map(TransitionApproval::summary).collect(Collectors.joining(", "));
        if (allowedDescriptions.isEmpty()) {
            return "Cannot transition from " + String.valueOf((Object)this.value) + " to " + String.valueOf((Object)target) + ". State is terminal.";
        }
        return "Cannot transition from " + String.valueOf((Object)this.value) + " to " + String.valueOf((Object)target) + ". Allowed transitions: " + allowedDescriptions + ".";
    }

    @Generated
    public State value() {
        return this.value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LifecycleState)) {
            return false;
        }
        LifecycleState other = (LifecycleState)o;
        State this$value = this.value();
        State other$value = other.value();
        return !(this$value == null ? other$value != null : !((Object)((Object)this$value)).equals((Object)other$value));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        State $value = this.value();
        result = result * 59 + ($value == null ? 43 : ((Object)((Object)$value)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LifecycleState(value=" + String.valueOf((Object)this.value()) + ")";
    }

    public static enum State {
        PROVISIONED,
        ACTIVE,
        SUSPENDED,
        DECOMMISSIONED;


        Map<State, TransitionApproval> transitionApprovals() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> Map.of(ACTIVE, TransitionApproval.of(ACTIVE, Set.of("Operations", "Security"), "Activation requires operations and security sign-off."), DECOMMISSIONED, TransitionApproval.of(DECOMMISSIONED, Set.of("Operations"), "Decommissioning a provisioned mint requires operations sign-off."));
                case 1 -> Map.of(SUSPENDED, TransitionApproval.of(SUSPENDED, Set.of("Operations"), "Suspending an active mint requires operations sign-off."), DECOMMISSIONED, TransitionApproval.of(DECOMMISSIONED, Set.of("Operations", "Security"), "Decommissioning an active mint requires operations and security sign-off."));
                case 2 -> Map.of(ACTIVE, TransitionApproval.of(ACTIVE, Set.of("Operations"), "Reactivating a suspended mint requires operations sign-off."), DECOMMISSIONED, TransitionApproval.of(DECOMMISSIONED, Set.of("Operations", "Security"), "Decommissioning a suspended mint requires operations and security sign-off."));
                case 3 -> Map.of();
            };
        }

        Optional<TransitionApproval> findApprovalFor(State target) {
            return Optional.ofNullable(this.transitionApprovals().get((Object)target));
        }
    }

    public record TransitionApproval(State target, Set<String> requiredSignoffs, String description) {
        public TransitionApproval {
            Objects.requireNonNull(target, "target state must not be null");
            Objects.requireNonNull(requiredSignoffs, "required sign-offs must not be null");
            Objects.requireNonNull(description, "description must not be null");
            requiredSignoffs = Set.copyOf(requiredSignoffs);
        }

        public static TransitionApproval of(State target, Set<String> requiredSignoffs, String description) {
            return new TransitionApproval(target, requiredSignoffs, description);
        }

        public static TransitionApproval noChange(State target) {
            return new TransitionApproval(target, Set.of(), "State remains unchanged.");
        }

        public String summary() {
            String signoffSummary = this.requiredSignoffs.isEmpty() ? "no approvals required" : "requires sign-off from: " + this.requiredSignoffs.stream().sorted().collect(Collectors.joining(", "));
            return String.valueOf((Object)this.target) + " (" + signoffSummary + "; " + this.description + ")";
        }
    }
}

