/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.domain;

import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import lombok.Generated;
import xyz.tcheeric.cashu.mint.admin.domain.AuditMetadata;
import xyz.tcheeric.cashu.mint.admin.domain.NotificationPolicy;

public final class NotificationPolicySnapshot {
    private final boolean emailEnabled;
    private final boolean webhookEnabled;
    private final Duration throttleInterval;
    private final String auditActor;
    private final String auditAction;
    private final Instant auditTimestamp;

    public NotificationPolicySnapshot(boolean emailEnabled, boolean webhookEnabled, Duration throttleInterval, String auditActor, String auditAction, Instant auditTimestamp) {
        this.emailEnabled = emailEnabled;
        this.webhookEnabled = webhookEnabled;
        this.throttleInterval = Objects.requireNonNull(throttleInterval, "throttle interval must not be null");
        this.auditActor = NotificationPolicySnapshot.requireNonBlank(auditActor, "audit actor");
        this.auditAction = NotificationPolicySnapshot.requireNonBlank(auditAction, "audit action");
        this.auditTimestamp = Objects.requireNonNull(auditTimestamp, "audit timestamp must not be null");
    }

    public static NotificationPolicySnapshot fromPolicy(NotificationPolicy policy) {
        Objects.requireNonNull(policy, "notification policy must not be null");
        AuditMetadata audit = policy.auditMetadata();
        return new NotificationPolicySnapshot(policy.emailEnabled(), policy.webhookEnabled(), policy.throttleInterval(), audit.actor(), audit.action(), audit.timestamp());
    }

    private static String requireNonBlank(String value, String fieldName) {
        if (value == null || value.isBlank()) {
            throw new IllegalArgumentException(fieldName + " must not be blank");
        }
        return value;
    }

    @Generated
    public boolean emailEnabled() {
        return this.emailEnabled;
    }

    @Generated
    public boolean webhookEnabled() {
        return this.webhookEnabled;
    }

    @Generated
    public Duration throttleInterval() {
        return this.throttleInterval;
    }

    @Generated
    public String auditActor() {
        return this.auditActor;
    }

    @Generated
    public String auditAction() {
        return this.auditAction;
    }

    @Generated
    public Instant auditTimestamp() {
        return this.auditTimestamp;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NotificationPolicySnapshot)) {
            return false;
        }
        NotificationPolicySnapshot other = (NotificationPolicySnapshot)o;
        if (this.emailEnabled() != other.emailEnabled()) {
            return false;
        }
        if (this.webhookEnabled() != other.webhookEnabled()) {
            return false;
        }
        Duration this$throttleInterval = this.throttleInterval();
        Duration other$throttleInterval = other.throttleInterval();
        if (this$throttleInterval == null ? other$throttleInterval != null : !((Object)this$throttleInterval).equals(other$throttleInterval)) {
            return false;
        }
        String this$auditActor = this.auditActor();
        String other$auditActor = other.auditActor();
        if (this$auditActor == null ? other$auditActor != null : !this$auditActor.equals(other$auditActor)) {
            return false;
        }
        String this$auditAction = this.auditAction();
        String other$auditAction = other.auditAction();
        if (this$auditAction == null ? other$auditAction != null : !this$auditAction.equals(other$auditAction)) {
            return false;
        }
        Instant this$auditTimestamp = this.auditTimestamp();
        Instant other$auditTimestamp = other.auditTimestamp();
        return !(this$auditTimestamp == null ? other$auditTimestamp != null : !((Object)this$auditTimestamp).equals(other$auditTimestamp));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.emailEnabled() ? 79 : 97);
        result = result * 59 + (this.webhookEnabled() ? 79 : 97);
        Duration $throttleInterval = this.throttleInterval();
        result = result * 59 + ($throttleInterval == null ? 43 : ((Object)$throttleInterval).hashCode());
        String $auditActor = this.auditActor();
        result = result * 59 + ($auditActor == null ? 43 : $auditActor.hashCode());
        String $auditAction = this.auditAction();
        result = result * 59 + ($auditAction == null ? 43 : $auditAction.hashCode());
        Instant $auditTimestamp = this.auditTimestamp();
        result = result * 59 + ($auditTimestamp == null ? 43 : ((Object)$auditTimestamp).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "NotificationPolicySnapshot(emailEnabled=" + this.emailEnabled() + ", webhookEnabled=" + this.webhookEnabled() + ", throttleInterval=" + String.valueOf(this.throttleInterval()) + ", auditActor=" + this.auditActor() + ", auditAction=" + this.auditAction() + ", auditTimestamp=" + String.valueOf(this.auditTimestamp()) + ")";
    }
}

