/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.cli;

import picocli.CommandLine;
import xyz.tcheeric.cashu.mint.admin.cli.command.MintAlertsCommand;
import xyz.tcheeric.cashu.mint.admin.cli.command.MintCommand;
import xyz.tcheeric.cashu.mint.admin.cli.command.MintConfigCommand;
import xyz.tcheeric.cashu.mint.admin.cli.command.MintCreateCommand;
import xyz.tcheeric.cashu.mint.admin.cli.command.MintPauseCommand;
import xyz.tcheeric.cashu.mint.admin.cli.command.MintResumeCommand;
import xyz.tcheeric.cashu.mint.admin.cli.command.MintRetireCommand;
import xyz.tcheeric.cashu.mint.admin.cli.command.MintUpdateCommand;
import xyz.tcheeric.cashu.mint.admin.cli.command.MintUsersCommand;
import xyz.tcheeric.cashu.mint.admin.cli.io.CommandPayloadMapper;
import xyz.tcheeric.cashu.mint.admin.cli.io.ResponseRenderingService;
import xyz.tcheeric.cashu.mint.admin.cli.port.MintAlertsPort;
import xyz.tcheeric.cashu.mint.admin.cli.port.MintConfigPort;
import xyz.tcheeric.cashu.mint.admin.cli.port.MintLifecyclePort;
import xyz.tcheeric.cashu.mint.admin.cli.port.MintStatusPort;
import xyz.tcheeric.cashu.mint.admin.cli.port.MintUsersPort;
import xyz.tcheeric.cashu.mint.admin.cli.port.stub.StubMintAlertsPort;
import xyz.tcheeric.cashu.mint.admin.cli.port.stub.StubMintConfigPort;
import xyz.tcheeric.cashu.mint.admin.cli.port.stub.StubMintLifecyclePort;
import xyz.tcheeric.cashu.mint.admin.cli.port.stub.StubMintStatusPort;
import xyz.tcheeric.cashu.mint.admin.cli.port.stub.StubMintUsersPort;
import xyz.tcheeric.cashu.mint.admin.cli.presentation.lifecycle.LifecycleSummaryCliPresenter;
import xyz.tcheeric.cashu.mint.admin.framework.CorrelationIdContext;

public final class MintAdminCliApplication {
    private MintAdminCliApplication() {
    }

    public static void main(String[] args) {
        CommandLine commandLine = MintAdminCliApplication.defaultCommandLine();
        int exitCode = commandLine.execute(args);
        System.exit(exitCode);
    }

    static CommandLine defaultCommandLine() {
        CommandPayloadMapper payloadMapper = CommandPayloadMapper.createDefault();
        ResponseRenderingService renderingService = ResponseRenderingService.createDefault(payloadMapper.jsonMapper());
        LifecycleSummaryCliPresenter lifecyclePresenter = new LifecycleSummaryCliPresenter(payloadMapper.jsonMapper());
        return MintAdminCliApplication.buildCommandLine(payloadMapper, renderingService, lifecyclePresenter, new StubMintStatusPort(), new StubMintConfigPort(), new StubMintUsersPort(), new StubMintAlertsPort(), new StubMintLifecyclePort());
    }

    static CommandLine buildCommandLine(CommandPayloadMapper payloadMapper, ResponseRenderingService renderingService, LifecycleSummaryCliPresenter lifecyclePresenter, MintStatusPort statusPort, MintConfigPort configPort, MintUsersPort usersPort, MintAlertsPort alertsPort, MintLifecyclePort lifecyclePort) {
        MintCommand root = new MintCommand(statusPort, payloadMapper, renderingService);
        CommandLine commandLine = new CommandLine((Object)root);
        commandLine.setCaseInsensitiveEnumValuesAllowed(true);
        commandLine.addSubcommand("config", (Object)new MintConfigCommand(configPort, payloadMapper, renderingService));
        commandLine.addSubcommand("users", (Object)new MintUsersCommand(usersPort, payloadMapper, renderingService));
        commandLine.addSubcommand("alerts", (Object)new MintAlertsCommand(alertsPort, payloadMapper, renderingService));
        commandLine.addSubcommand("create", (Object)new MintCreateCommand(lifecyclePort, payloadMapper, lifecyclePresenter));
        commandLine.addSubcommand("update", (Object)new MintUpdateCommand(lifecyclePort, payloadMapper, lifecyclePresenter));
        commandLine.addSubcommand("pause", (Object)new MintPauseCommand(lifecyclePort, payloadMapper, lifecyclePresenter));
        commandLine.addSubcommand("resume", (Object)new MintResumeCommand(lifecyclePort, payloadMapper, lifecyclePresenter));
        commandLine.addSubcommand("retire", (Object)new MintRetireCommand(lifecyclePort, payloadMapper, lifecyclePresenter));
        commandLine.setExecutionStrategy(MintAdminCliApplication::executeWithCorrelationId);
        return commandLine;
    }

    private static int executeWithCorrelationId(CommandLine.ParseResult parseResult) {
        try (CorrelationIdContext.Scope ignored = CorrelationIdContext.open();){
            int n = new CommandLine.RunLast().execute(parseResult);
            return n;
        }
    }
}

