/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.cli.command;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import picocli.CommandLine;
import xyz.tcheeric.cashu.mint.admin.cli.io.CommandPayloadMapper;
import xyz.tcheeric.cashu.mint.admin.cli.io.InputFormat;
import xyz.tcheeric.cashu.mint.admin.cli.io.OutputFormat;
import xyz.tcheeric.cashu.mint.admin.cli.io.PayloadMappingException;

final class CommandIOOptions {
    @CommandLine.Option(names={"-f", "--input-format"}, description={"Payload format: <${COMPLETION-CANDIDATES}>"}, defaultValue="JSON")
    private InputFormat inputFormat = InputFormat.JSON;
    @CommandLine.Option(names={"-p", "--payload"}, description={"Inline payload in the selected input format."})
    private String inlinePayload;
    @CommandLine.Option(names={"-F", "--payload-file"}, description={"Path to a file containing the payload in the selected input format."})
    private Path payloadFile;
    @CommandLine.Option(names={"-o", "--output-format"}, description={"Response render format: <${COMPLETION-CANDIDATES}>"}, defaultValue="TABLE")
    private OutputFormat outputFormat = OutputFormat.TABLE;

    CommandIOOptions() {
    }

    InputFormat inputFormat() {
        return this.inputFormat;
    }

    OutputFormat outputFormat() {
        return this.outputFormat;
    }

    <T> Optional<T> readPayload(CommandPayloadMapper mapper, Class<T> targetType) {
        return this.resolvePayload().map(content -> mapper.read((String)content, this.inputFormat, targetType));
    }

    private Optional<String> resolvePayload() {
        if (this.inlinePayload != null && this.payloadFile != null) {
            throw new PayloadMappingException("Specify either --payload or --payload-file, not both.");
        }
        if (this.inlinePayload != null) {
            return Optional.of(this.inlinePayload);
        }
        if (this.payloadFile != null) {
            try {
                return Optional.of(Files.readString(this.payloadFile));
            }
            catch (IOException ex) {
                throw new PayloadMappingException("Failed to read payload file '%s'".formatted(this.payloadFile), ex);
            }
        }
        return Optional.empty();
    }
}

