/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.cli.io;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.util.Objects;
import xyz.tcheeric.cashu.mint.admin.cli.io.InputFormat;
import xyz.tcheeric.cashu.mint.admin.cli.io.PayloadMappingException;

public final class CommandPayloadMapper {
    private final ObjectMapper jsonMapper;
    private final ObjectMapper yamlMapper;

    public CommandPayloadMapper(ObjectMapper jsonMapper, ObjectMapper yamlMapper) {
        this.jsonMapper = Objects.requireNonNull(jsonMapper, "jsonMapper");
        this.yamlMapper = Objects.requireNonNull(yamlMapper, "yamlMapper");
    }

    public static CommandPayloadMapper createDefault() {
        ObjectMapper json = new ObjectMapper();
        json.findAndRegisterModules();
        ObjectMapper yaml = new ObjectMapper((JsonFactory)new YAMLFactory());
        yaml.findAndRegisterModules();
        return new CommandPayloadMapper(json, yaml);
    }

    public ObjectMapper jsonMapper() {
        return this.jsonMapper;
    }

    public <T> T read(String payload, InputFormat format, Class<T> type) {
        Objects.requireNonNull(payload, "payload");
        Objects.requireNonNull(format, "format");
        Objects.requireNonNull(type, "type");
        try {
            return (T)this.selectMapper(format).readValue(payload, type);
        }
        catch (JsonProcessingException ex) {
            throw new PayloadMappingException("Failed to parse payload for " + type.getSimpleName(), ex);
        }
    }

    private ObjectMapper selectMapper(InputFormat format) {
        return switch (format) {
            default -> throw new MatchException(null, null);
            case InputFormat.JSON -> this.jsonMapper;
            case InputFormat.YAML -> this.yamlMapper;
        };
    }
}

