/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.rest.config;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import xyz.tcheeric.cashu.mint.admin.rest.config.AdminSecurityProperties;
import xyz.tcheeric.cashu.mint.admin.rest.config.MessageDigestComparator;

public class AdminAuthenticationFilter
extends OncePerRequestFilter {
    public static final String ADMIN_TOKEN_HEADER = "X-Admin-Token";
    private final AdminSecurityProperties properties;

    public AdminAuthenticationFilter(AdminSecurityProperties properties) {
        this.properties = Objects.requireNonNull(properties, "properties");
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!request.getRequestURI().startsWith("/admin")) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if ("OPTIONS".equalsIgnoreCase(request.getMethod())) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String providedToken = request.getHeader(ADMIN_TOKEN_HEADER);
        if (!StringUtils.hasText((String)providedToken) || !MessageDigestComparator.equals((String)this.properties.apiToken(), (String)providedToken)) {
            response.setStatus(HttpStatus.UNAUTHORIZED.value());
            response.setHeader("WWW-Authenticate", "Token realm=admin");
            response.setContentType("application/json");
            response.getOutputStream().write("{\"error\":\"unauthorized\"}".getBytes(StandardCharsets.UTF_8));
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

