/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.rest.config;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import xyz.tcheeric.cashu.mint.admin.framework.CorrelationIdContext;

public class AdminCorrelationIdFilter
extends OncePerRequestFilter {
    public static final String CORRELATION_ID_HEADER = "X-Correlation-ID";
    public static final String CORRELATION_ID_ATTRIBUTE = AdminCorrelationIdFilter.class.getName() + ".CORRELATION_ID";

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String suppliedId = request.getHeader(CORRELATION_ID_HEADER);
        try (CorrelationIdContext.Scope scope = CorrelationIdContext.open((String)(StringUtils.hasText((String)suppliedId) ? suppliedId : null));){
            String correlationId = scope.correlationId();
            request.setAttribute(CORRELATION_ID_ATTRIBUTE, (Object)correlationId);
            response.setHeader(CORRELATION_ID_HEADER, correlationId);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }
}

