/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.rest.config;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AdminOpenApiConfiguration {
    private static final String ADMIN_TOKEN_SCHEME = "AdminToken";
    private static final String ADMIN_ROLES_SCHEME = "AdminRoles";

    @Bean
    public OpenAPI adminOpenApi() {
        Components components = new Components().addSecuritySchemes(ADMIN_TOKEN_SCHEME, new SecurityScheme().type(SecurityScheme.Type.APIKEY).name("X-Admin-Token").in(SecurityScheme.In.HEADER)).addSecuritySchemes(ADMIN_ROLES_SCHEME, new SecurityScheme().type(SecurityScheme.Type.APIKEY).name("X-Admin-Roles").in(SecurityScheme.In.HEADER));
        SecurityRequirement securityRequirement = new SecurityRequirement().addList(ADMIN_TOKEN_SCHEME).addList(ADMIN_ROLES_SCHEME);
        return new OpenAPI().components(components).info(new Info().title("Cashu Mint Admin API").description("Administrative endpoints mirroring CLI workflows").version("v1")).addSecurityItem(securityRequirement);
    }
}

