/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.rest.config;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class AdminRbacFilter
extends OncePerRequestFilter {
    public static final String ADMIN_ROLES_HEADER = "X-Admin-Roles";
    private static final Map<String, String> REQUIRED_ROLE_BY_PATTERN = Map.of("/admin/lifecycle/**", "MINT_ADMIN", "/admin/configuration/**", "MINT_ADMIN", "/admin/users/**", "USER_ADMIN", "/admin/alerts/**", "ALERTS_ADMIN");
    private final AntPathMatcher pathMatcher = new AntPathMatcher();

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String uri = request.getRequestURI();
        if (!uri.startsWith("/admin") || "OPTIONS".equalsIgnoreCase(request.getMethod())) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String requiredRole = this.resolveRequiredRole(uri);
        if (requiredRole == null) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        Set callerRoles = this.extractRoles(request.getHeader(ADMIN_ROLES_HEADER));
        if (callerRoles.contains(requiredRole)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String payload = "{\"status\":" + HttpStatus.FORBIDDEN.value() + ",\"error\":\"Forbidden\",\"code\":\"forbidden\",\"message\":\"Missing required role: " + requiredRole + "\"}";
        response.setStatus(HttpStatus.FORBIDDEN.value());
        response.setContentType("application/json");
        response.getOutputStream().write(payload.getBytes(StandardCharsets.UTF_8));
    }

    private String resolveRequiredRole(String uri) {
        for (Map.Entry entry : REQUIRED_ROLE_BY_PATTERN.entrySet()) {
            if (!this.pathMatcher.match((String)entry.getKey(), uri)) continue;
            return (String)entry.getValue();
        }
        return null;
    }

    private Set<String> extractRoles(String headerValue) {
        if (!StringUtils.hasText((String)headerValue)) {
            return Set.of();
        }
        return Arrays.stream(headerValue.split(",")).map(String::trim).filter(StringUtils::hasText).map(value -> value.toUpperCase(Locale.ROOT)).collect(Collectors.toUnmodifiableSet());
    }
}

