/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.rest.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import xyz.tcheeric.cashu.mint.admin.rest.dto.common.AdminErrorResponse;
import xyz.tcheeric.cashu.mint.admin.rest.dto.lifecycle.CreateMintRequest;
import xyz.tcheeric.cashu.mint.admin.rest.dto.lifecycle.LifecycleActionResponse;
import xyz.tcheeric.cashu.mint.admin.rest.dto.lifecycle.LifecycleChangeRequest;
import xyz.tcheeric.cashu.mint.admin.rest.dto.lifecycle.UpdateMintRequest;
import xyz.tcheeric.cashu.mint.admin.rest.service.AdminLifecycleService;

@Tag(name="Admin Lifecycle", description="Lifecycle workflows mirrored from CLI commands")
@SecurityRequirements(value={@SecurityRequirement(name="AdminToken"), @SecurityRequirement(name="AdminRoles")})
@RestController
@RequestMapping(value={"/admin/lifecycle"})
public class LifecycleAdminController {
    private final AdminLifecycleService lifecycleService;

    public LifecycleAdminController(AdminLifecycleService lifecycleService) {
        this.lifecycleService = lifecycleService;
    }

    @Operation(summary="Provision a mint", description="Creates a new mint instance just like the `mint create` CLI command.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Mint created", content={@Content(schema=@Schema(implementation=LifecycleActionResponse.class))}), @ApiResponse(responseCode="409", description="Mint already exists", content={@Content(schema=@Schema(implementation=AdminErrorResponse.class))})})
    @PostMapping(value={"/mints"})
    public ResponseEntity<LifecycleActionResponse> createMint(@Valid @RequestBody CreateMintRequest request) {
        return ResponseEntity.ok((Object)this.lifecycleService.createMint(request));
    }

    @Operation(summary="Update a mint", description="Updates metadata or configuration bindings, mirroring `mint update`.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Mint updated", content={@Content(schema=@Schema(implementation=LifecycleActionResponse.class))}), @ApiResponse(responseCode="404", description="Mint not found", content={@Content(schema=@Schema(implementation=AdminErrorResponse.class))})})
    @PutMapping(value={"/mints/{mintId}"})
    public ResponseEntity<LifecycleActionResponse> updateMint(@PathVariable(value="mintId") String mintId, @Valid @RequestBody UpdateMintRequest request) {
        return ResponseEntity.ok((Object)this.lifecycleService.updateMint(mintId, request));
    }

    @Operation(summary="Pause mint operations", description="Pauses a mint for maintenance, mirroring `mint pause`.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Mint paused", content={@Content(schema=@Schema(implementation=LifecycleActionResponse.class))}), @ApiResponse(responseCode="404", description="Mint not found", content={@Content(schema=@Schema(implementation=AdminErrorResponse.class))})})
    @PostMapping(value={"/mints/{mintId}/pause"})
    public ResponseEntity<LifecycleActionResponse> pauseMint(@PathVariable(value="mintId") String mintId, @Valid @RequestBody LifecycleChangeRequest request) {
        return ResponseEntity.ok((Object)this.lifecycleService.pauseMint(mintId, request));
    }

    @Operation(summary="Resume mint operations", description="Resumes a paused mint, mirroring `mint resume`.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Mint resumed", content={@Content(schema=@Schema(implementation=LifecycleActionResponse.class))}), @ApiResponse(responseCode="404", description="Mint not found", content={@Content(schema=@Schema(implementation=AdminErrorResponse.class))})})
    @PostMapping(value={"/mints/{mintId}/resume"})
    public ResponseEntity<LifecycleActionResponse> resumeMint(@PathVariable(value="mintId") String mintId, @Valid @RequestBody LifecycleChangeRequest request) {
        return ResponseEntity.ok((Object)this.lifecycleService.resumeMint(mintId, request));
    }

    @Operation(summary="Retire a mint", description="Retires a mint and revokes access, mirroring `mint retire`.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Mint retired", content={@Content(schema=@Schema(implementation=LifecycleActionResponse.class))}), @ApiResponse(responseCode="404", description="Mint not found", content={@Content(schema=@Schema(implementation=AdminErrorResponse.class))})})
    @PostMapping(value={"/mints/{mintId}/retire"})
    public ResponseEntity<LifecycleActionResponse> retireMint(@PathVariable(value="mintId") String mintId, @Valid @RequestBody LifecycleChangeRequest request) {
        return ResponseEntity.ok((Object)this.lifecycleService.retireMint(mintId, request));
    }
}

