/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.rest.service;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import xyz.tcheeric.cashu.mint.admin.rest.dto.alerts.AlertActionRequest;
import xyz.tcheeric.cashu.mint.admin.rest.dto.alerts.AlertActionResponse;
import xyz.tcheeric.cashu.mint.admin.rest.dto.alerts.CreateAlertRequest;
import xyz.tcheeric.cashu.mint.admin.rest.dto.alerts.EscalateAlertRequest;
import xyz.tcheeric.cashu.mint.admin.rest.dto.alerts.SilenceAlertRequest;
import xyz.tcheeric.cashu.mint.admin.rest.service.AdminAlertService;
import xyz.tcheeric.cashu.mint.admin.rest.service.AdminServiceException;

@Service
public class AdminAlertService {
    private final ConcurrentMap<String, AlertRecord> alerts = new ConcurrentHashMap();

    public AlertActionResponse createAlert(CreateAlertRequest request) {
        Objects.requireNonNull(request, "request");
        AlertRecord record = new AlertRecord(request.alertId(), request.mintId(), request.severity(), request.summary(), request.labels());
        AlertRecord existing = this.alerts.putIfAbsent(record.alertId, record);
        if (existing != null) {
            throw new AdminServiceException(HttpStatus.CONFLICT, "alert_exists", "Alert already exists: " + request.alertId());
        }
        return record.toResponse("Alert created");
    }

    public AlertActionResponse acknowledgeAlert(String alertId, AlertActionRequest request) {
        Objects.requireNonNull(request, "request");
        AlertRecord record = this.alerts.computeIfPresent(alertId, (id, current) -> {
            current.acknowledged = true;
            return current;
        });
        if (record == null) {
            throw new AdminServiceException(HttpStatus.NOT_FOUND, "alert_not_found", "Alert not found: " + alertId);
        }
        return record.toResponse("Alert acknowledged");
    }

    public AlertActionResponse silenceAlert(String alertId, SilenceAlertRequest request) {
        Objects.requireNonNull(request, "request");
        AlertRecord record = this.alerts.computeIfPresent(alertId, (id, current) -> {
            current.silenced = true;
            current.silenceMinutes = request.durationMinutes();
            return current;
        });
        if (record == null) {
            throw new AdminServiceException(HttpStatus.NOT_FOUND, "alert_not_found", "Alert not found: " + alertId);
        }
        return record.toResponse("Alert silenced for " + request.durationMinutes() + " minutes");
    }

    public AlertActionResponse unsilenceAlert(String alertId, AlertActionRequest request) {
        Objects.requireNonNull(request, "request");
        AlertRecord record = this.alerts.computeIfPresent(alertId, (id, current) -> {
            current.silenced = false;
            current.silenceMinutes = null;
            return current;
        });
        if (record == null) {
            throw new AdminServiceException(HttpStatus.NOT_FOUND, "alert_not_found", "Alert not found: " + alertId);
        }
        return record.toResponse("Alert unsilenced");
    }

    public AlertActionResponse escalateAlert(String alertId, EscalateAlertRequest request) {
        Objects.requireNonNull(request, "request");
        AlertRecord record = this.alerts.computeIfPresent(alertId, (id, current) -> {
            if (!current.escalations.contains(request.policyId())) {
                current.escalations.add(request.policyId());
            }
            return current;
        });
        if (record == null) {
            throw new AdminServiceException(HttpStatus.NOT_FOUND, "alert_not_found", "Alert not found: " + alertId);
        }
        return record.toResponse("Alert escalated to " + request.policyId());
    }
}

