/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.rest.service;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.stereotype.Service;
import xyz.tcheeric.cashu.mint.admin.rest.dto.configuration.ApplyConfigurationRequest;
import xyz.tcheeric.cashu.mint.admin.rest.dto.configuration.ConfigurationActionResponse;
import xyz.tcheeric.cashu.mint.admin.rest.dto.configuration.PreviewConfigurationRequest;
import xyz.tcheeric.cashu.mint.admin.rest.dto.configuration.RollbackConfigurationRequest;
import xyz.tcheeric.cashu.mint.admin.rest.service.AdminConfigurationService;

@Service
public class AdminConfigurationService {
    private static final Map<String, String> BASELINE_CONFIGURATION = Map.of("currency", "sat", "maxTokens", "1000");
    private final ConcurrentMap<String, ConfigurationHistory> histories = new ConcurrentHashMap();

    public ConfigurationActionResponse previewConfiguration(String mintId, PreviewConfigurationRequest request) {
        Objects.requireNonNull(request, "request");
        ConfigurationHistory history = this.histories.computeIfAbsent(mintId, k -> new ConfigurationHistory());
        return history.preview(mintId, request);
    }

    public ConfigurationActionResponse applyConfiguration(String mintId, ApplyConfigurationRequest request) {
        Objects.requireNonNull(request, "request");
        ConfigurationHistory history = this.histories.computeIfAbsent(mintId, k -> new ConfigurationHistory());
        return history.apply(mintId, request);
    }

    public ConfigurationActionResponse rollbackConfiguration(String mintId, RollbackConfigurationRequest request) {
        Objects.requireNonNull(request, "request");
        ConfigurationHistory history = this.histories.computeIfAbsent(mintId, k -> new ConfigurationHistory());
        return history.rollback(mintId, request);
    }

    private static Map<String, String> normalizeParameters(Map<String, Object> parameters, Map<String, String> startingPoint) {
        LinkedHashMap<String, String> merged = new LinkedHashMap<String, String>(startingPoint);
        if (parameters == null) {
            return merged;
        }
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value == null) {
                merged.remove(key);
                continue;
            }
            merged.put(key, String.valueOf(value));
        }
        return Map.copyOf(merged);
    }
}

