/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.rest.service;

import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import xyz.tcheeric.cashu.mint.admin.rest.dto.users.AssignRolesRequest;
import xyz.tcheeric.cashu.mint.admin.rest.dto.users.CreateUserRequest;
import xyz.tcheeric.cashu.mint.admin.rest.dto.users.CredentialResetResponse;
import xyz.tcheeric.cashu.mint.admin.rest.dto.users.ResetCredentialsRequest;
import xyz.tcheeric.cashu.mint.admin.rest.dto.users.UpdateUserRequest;
import xyz.tcheeric.cashu.mint.admin.rest.dto.users.UserLifecycleRequest;
import xyz.tcheeric.cashu.mint.admin.rest.dto.users.UserResponse;
import xyz.tcheeric.cashu.mint.admin.rest.service.AdminServiceException;
import xyz.tcheeric.cashu.mint.admin.rest.service.AdminUserService;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class AdminUserService {
    private final ConcurrentMap<String, UserRecord> users = new ConcurrentHashMap();
    private final AtomicInteger resetSequence = new AtomicInteger(1);

    public UserResponse createUser(CreateUserRequest request) {
        Objects.requireNonNull(request, "request");
        UserRecord newUser = new UserRecord(request.userId(), request.displayName(), request.email(), Set.copyOf(request.roles()), true);
        UserRecord existing = this.users.putIfAbsent(newUser.userId, newUser);
        if (existing != null) {
            throw new AdminServiceException(HttpStatus.CONFLICT, "user_exists", "User already exists: " + request.userId());
        }
        return AdminUserService.toResponse((UserRecord)newUser, (String)"User created");
    }

    public UserResponse updateUser(String userId, UpdateUserRequest request) {
        Objects.requireNonNull(request, "request");
        UserRecord updated = this.users.computeIfPresent(userId, (id, current) -> {
            current.displayName = request.displayName();
            current.email = request.email();
            current.roles = Set.copyOf(request.roles());
            return current;
        });
        if (updated == null) {
            throw new AdminServiceException(HttpStatus.NOT_FOUND, "user_not_found", "User not found: " + userId);
        }
        return AdminUserService.toResponse((UserRecord)updated, (String)"User updated");
    }

    public UserResponse assignRoles(String userId, AssignRolesRequest request) {
        Objects.requireNonNull(request, "request");
        UserRecord updated = this.users.computeIfPresent(userId, (id, current) -> {
            current.roles = Set.copyOf(request.roles());
            return current;
        });
        if (updated == null) {
            throw new AdminServiceException(HttpStatus.NOT_FOUND, "user_not_found", "User not found: " + userId);
        }
        return AdminUserService.toResponse((UserRecord)updated, (String)"Roles updated");
    }

    public CredentialResetResponse resetCredentials(String userId, ResetCredentialsRequest request) {
        Objects.requireNonNull(request, "request");
        UserRecord user = (UserRecord)this.users.get(userId);
        if (user == null) {
            throw new AdminServiceException(HttpStatus.NOT_FOUND, "user_not_found", "User not found: " + userId);
        }
        String token = userId + "-reset-" + this.resetSequence.getAndIncrement();
        user.lastResetToken = token;
        return new CredentialResetResponse(userId, token, "Reset token issued");
    }

    public UserResponse deactivateUser(String userId, UserLifecycleRequest request) {
        Objects.requireNonNull(request, "request");
        UserRecord updated = this.users.computeIfPresent(userId, (id, current) -> {
            current.active = false;
            return current;
        });
        if (updated == null) {
            throw new AdminServiceException(HttpStatus.NOT_FOUND, "user_not_found", "User not found: " + userId);
        }
        return AdminUserService.toResponse((UserRecord)updated, (String)"User deactivated");
    }

    private static UserResponse toResponse(UserRecord record, String message) {
        return new UserResponse(record.userId, record.displayName, record.email, record.roles, record.active, message);
    }
}

