/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.adapter.out.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.sql.DataSource;
import xyz.tcheeric.cashu.mint.admin.adapter.out.jdbc.JdbcRepositoryException;
import xyz.tcheeric.cashu.mint.admin.application.port.out.MintAggregateViewRepository;
import xyz.tcheeric.cashu.mint.admin.application.port.out.MintLifecycleEvent;
import xyz.tcheeric.cashu.mint.admin.domain.ConfigurationRevisionId;
import xyz.tcheeric.cashu.mint.admin.domain.LifecycleState;
import xyz.tcheeric.cashu.mint.admin.domain.MintId;

public class JdbcMintAggregateViewRepository
implements MintAggregateViewRepository {
    private static final String UPSERT_SQL = "    INSERT INTO mint_aggregate_snapshots (\n        mint_id,\n        lifecycle_state,\n        configuration_revision_id,\n        version_tag,\n        updated_at,\n        audit_request_id,\n        audit_correlation_id)\n    VALUES (?, ?, ?, ?, ?, ?, ?)\n    ON CONFLICT (mint_id) DO UPDATE SET\n        lifecycle_state = EXCLUDED.lifecycle_state,\n        configuration_revision_id = EXCLUDED.configuration_revision_id,\n        version_tag = EXCLUDED.version_tag,\n        updated_at = EXCLUDED.updated_at,\n        audit_request_id = EXCLUDED.audit_request_id,\n        audit_correlation_id = EXCLUDED.audit_correlation_id\n";
    private static final String H2_UPSERT_SQL = "    MERGE INTO mint_aggregate_snapshots (\n        mint_id,\n        lifecycle_state,\n        configuration_revision_id,\n        version_tag,\n        updated_at,\n        audit_request_id,\n        audit_correlation_id)\n    KEY (mint_id)\n    VALUES (?, ?, ?, ?, ?, ?, ?)\n";
    private static final String SELECT_ONE_SQL = "    SELECT lifecycle_state, configuration_revision_id, version_tag, updated_at\n    FROM mint_aggregate_snapshots\n    WHERE mint_id = ?\n";
    private static final String SELECT_ALL_SQL = "    SELECT mint_id, lifecycle_state, configuration_revision_id, version_tag, updated_at\n    FROM mint_aggregate_snapshots\n    ORDER BY mint_id\n";
    private final DataSource dataSource;

    public JdbcMintAggregateViewRepository(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public void upsert(MintLifecycleEvent event) {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = this.prepareUpsert(connection);){
            statement.setObject(1, event.mintId().value());
            statement.setString(2, event.currentState().name());
            statement.setLong(3, event.configurationRevisionId().value());
            statement.setString(4, event.versionTag());
            statement.setTimestamp(5, Timestamp.from(event.auditMetadata().timestamp()));
            statement.setObject(6, event.auditMetadata().requestId());
            statement.setString(7, event.auditMetadata().correlationId());
            statement.executeUpdate();
        }
        catch (SQLException ex) {
            throw new JdbcRepositoryException("Failed to persist mint aggregate snapshot", ex);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Optional<MintAggregateViewRepository.MintAggregateView> findById(MintId mintId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<MintAggregateViewRepository.MintAggregateView> findAll() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private PreparedStatement prepareUpsert(Connection connection) throws SQLException {
        if (this.isH2(connection)) {
            return connection.prepareStatement(H2_UPSERT_SQL);
        }
        return connection.prepareStatement(UPSERT_SQL);
    }

    private boolean isH2(Connection connection) throws SQLException {
        String productName = connection.getMetaData().getDatabaseProductName();
        return "H2".equalsIgnoreCase(productName);
    }

    private MintAggregateViewRepository.MintAggregateView mapRow(Object rawMintId, ResultSet resultSet) throws SQLException {
        UUID id;
        UUID uuid = rawMintId instanceof UUID ? (id = (UUID)rawMintId) : UUID.fromString(rawMintId.toString());
        MintId mintId = MintId.of(uuid);
        LifecycleState.State state = LifecycleState.State.valueOf(resultSet.getString("lifecycle_state"));
        long revision = resultSet.getLong("configuration_revision_id");
        String versionTag = resultSet.getString("version_tag");
        Instant updatedAt = resultSet.getTimestamp("updated_at").toInstant();
        return new MintAggregateViewRepository.MintAggregateView(mintId, state, ConfigurationRevisionId.of(revision), versionTag, updatedAt);
    }
}

