/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.adapter.out.outbox;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import xyz.tcheeric.cashu.mint.admin.adapter.out.outbox.OutboxMessageHandlingException;
import xyz.tcheeric.cashu.mint.admin.application.port.out.MintAggregateViewRepository;
import xyz.tcheeric.cashu.mint.admin.application.port.out.MintLifecycleEvent;
import xyz.tcheeric.cashu.mint.admin.application.port.out.MintLifecycleHistoryRepository;
import xyz.tcheeric.cashu.mint.admin.domain.AuditMetadata;
import xyz.tcheeric.cashu.mint.admin.domain.AutomationContext;
import xyz.tcheeric.cashu.mint.admin.domain.ConfigurationRevisionId;
import xyz.tcheeric.cashu.mint.admin.domain.LifecycleContext;
import xyz.tcheeric.cashu.mint.admin.domain.LifecycleState;
import xyz.tcheeric.cashu.mint.admin.domain.MintId;
import xyz.tcheeric.cashu.mint.admin.domain.OutboxMessage;

public class LifecycleEventOutboxHandler {
    private final MintAggregateViewRepository aggregateViewRepository;
    private final MintLifecycleHistoryRepository historyRepository;
    private final ObjectMapper objectMapper;

    public LifecycleEventOutboxHandler(MintAggregateViewRepository aggregateViewRepository, MintLifecycleHistoryRepository historyRepository, ObjectMapper objectMapper) {
        this.aggregateViewRepository = Objects.requireNonNull(aggregateViewRepository, "aggregate view repository must not be null");
        this.historyRepository = Objects.requireNonNull(historyRepository, "lifecycle history repository must not be null");
        this.objectMapper = Objects.requireNonNull(objectMapper, "object mapper must not be null");
    }

    public MintLifecycleEvent handle(OutboxMessage message) {
        Objects.requireNonNull(message, "outbox message must not be null");
        LifecycleEventPayload payload = this.readPayload(message);
        if (payload.eventId() != null && !message.eventId().toString().equals(payload.eventId())) {
            throw new OutboxMessageHandlingException("Outbox payload event id does not match message id: " + String.valueOf(message.eventId()));
        }
        MintLifecycleEvent event = this.toEvent(payload);
        this.aggregateViewRepository.upsert(event);
        this.historyRepository.append(message.eventId(), event);
        return event;
    }

    private LifecycleEventPayload readPayload(OutboxMessage message) {
        try {
            return (LifecycleEventPayload)this.objectMapper.readValue(message.payload(), LifecycleEventPayload.class);
        }
        catch (JsonProcessingException ex) {
            throw new OutboxMessageHandlingException("Failed to deserialize lifecycle event payload", ex);
        }
    }

    private MintLifecycleEvent toEvent(LifecycleEventPayload payload) {
        MintLifecycleEvent.MintLifecycleEventType type = this.parseType(payload.type());
        MintId mintId = MintId.fromString(this.requireNonBlank(payload.mintId(), "mintId"));
        LifecycleState.State currentState = this.parseState(payload.currentState(), "currentState");
        LifecycleState.State previousState = payload.previousState() == null || payload.previousState().isBlank() ? null : this.parseState(payload.previousState(), "previousState");
        Long revisionValue = Objects.requireNonNull(payload.configurationRevision(), "configuration revision must not be null");
        ConfigurationRevisionId revision = ConfigurationRevisionId.of(revisionValue);
        String versionTag = this.requireNonBlank(payload.versionTag(), "versionTag");
        AuditMetadata audit = this.toAuditMetadata(payload.audit());
        return switch (type) {
            default -> throw new MatchException(null, null);
            case MintLifecycleEvent.MintLifecycleEventType.CREATED -> MintLifecycleEvent.created(mintId, currentState, revision, versionTag, audit);
            case MintLifecycleEvent.MintLifecycleEventType.CONFIGURATION_UPDATED -> MintLifecycleEvent.configurationUpdated(mintId, currentState, revision, versionTag, audit);
            case MintLifecycleEvent.MintLifecycleEventType.PAUSED -> MintLifecycleEvent.paused(mintId, this.requireState(previousState, type), currentState, revision, versionTag, audit);
            case MintLifecycleEvent.MintLifecycleEventType.RESUMED -> MintLifecycleEvent.resumed(mintId, this.requireState(previousState, type), currentState, revision, versionTag, audit);
            case MintLifecycleEvent.MintLifecycleEventType.RETIRED -> MintLifecycleEvent.retired(mintId, this.requireState(previousState, type), currentState, revision, versionTag, audit);
        };
    }

    private MintLifecycleEvent.MintLifecycleEventType parseType(String type) {
        try {
            return MintLifecycleEvent.MintLifecycleEventType.valueOf(this.requireNonBlank(type, "type"));
        }
        catch (IllegalArgumentException ex) {
            throw new OutboxMessageHandlingException("Unsupported lifecycle event type: " + type, ex);
        }
    }

    private LifecycleState.State parseState(String value, String field) {
        try {
            return LifecycleState.State.valueOf(this.requireNonBlank(value, field));
        }
        catch (IllegalArgumentException ex) {
            throw new OutboxMessageHandlingException("Invalid lifecycle state for " + field + ": " + value, ex);
        }
    }

    private LifecycleState.State requireState(LifecycleState.State state, MintLifecycleEvent.MintLifecycleEventType type) {
        if (state == null) {
            throw new OutboxMessageHandlingException("Lifecycle event " + String.valueOf((Object)type) + " missing previous state");
        }
        return state;
    }

    private AuditMetadata toAuditMetadata(AuditPayload auditPayload) {
        Instant timestamp;
        if (auditPayload == null) {
            throw new OutboxMessageHandlingException("Lifecycle event payload missing audit metadata");
        }
        try {
            timestamp = Instant.parse(this.requireNonBlank(auditPayload.timestamp(), "audit.timestamp"));
        }
        catch (DateTimeParseException ex) {
            throw new OutboxMessageHandlingException("Invalid audit timestamp: " + auditPayload.timestamp(), ex);
        }
        List<String> reasons = auditPayload.reasonCodes() == null ? List.of() : List.copyOf(auditPayload.reasonCodes());
        List<String> tickets = auditPayload.ticketReferences() == null ? List.of() : List.copyOf(auditPayload.ticketReferences());
        AutomationPayload automationPayload = auditPayload.automation();
        AutomationContext automationContext = automationPayload == null ? AutomationContext.manual() : new AutomationContext(Boolean.TRUE.equals(automationPayload.automated()), automationPayload.system(), automationPayload.runId());
        UUID requestId = this.parseRequestId(auditPayload.requestId());
        return new AuditMetadata(this.requireNonBlank(auditPayload.actor(), "audit.actor"), this.requireNonBlank(auditPayload.action(), "audit.action"), timestamp, reasons, tickets, automationContext, LifecycleContext.empty(), requestId, auditPayload.correlationId());
    }

    private String requireNonBlank(String value, String field) {
        if (value == null || value.isBlank()) {
            throw new OutboxMessageHandlingException(field + " must not be blank");
        }
        return value;
    }

    private UUID parseRequestId(String requestId) {
        if (requestId == null || requestId.isBlank()) {
            return null;
        }
        try {
            return UUID.fromString(requestId.trim());
        }
        catch (IllegalArgumentException ex) {
            throw new OutboxMessageHandlingException("Invalid audit request id: " + requestId, ex);
        }
    }

    private record LifecycleEventPayload(String eventId, String type, String mintId, String previousState, String currentState, Long configurationRevision, String versionTag, AuditPayload audit) {
    }

    private record AuditPayload(String actor, String action, String timestamp, List<String> reasonCodes, List<String> ticketReferences, AutomationPayload automation, String requestId, String correlationId) {
    }

    private record AutomationPayload(Boolean automated, String system, String runId) {
    }
}

