/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.admin.adapter.out.outbox;

import java.util.Objects;
import java.util.function.Consumer;
import xyz.tcheeric.cashu.mint.admin.adapter.out.outbox.LifecycleEventOutboxDispatcher;

public final class LifecycleEventOutboxTask
implements Runnable {
    private final LifecycleEventOutboxDispatcher dispatcher;
    private final int batchSize;
    private final Consumer<? super RuntimeException> errorHandler;

    public LifecycleEventOutboxTask(LifecycleEventOutboxDispatcher dispatcher, int batchSize) {
        this(dispatcher, batchSize, ex -> {});
    }

    public LifecycleEventOutboxTask(LifecycleEventOutboxDispatcher dispatcher, int batchSize, Consumer<? super RuntimeException> errorHandler) {
        if (batchSize <= 0) {
            throw new IllegalArgumentException("batch size must be positive");
        }
        this.dispatcher = Objects.requireNonNull(dispatcher, "dispatcher must not be null");
        this.batchSize = batchSize;
        this.errorHandler = Objects.requireNonNull(errorHandler, "error handler must not be null");
    }

    @Override
    public void run() {
        try {
            this.dispatcher.dispatchPending(this.batchSize);
        }
        catch (RuntimeException ex) {
            this.errorHandler.accept(ex);
        }
    }
}

