/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.proto.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.common.KeySet;
import xyz.tcheeric.cashu.common.Keys;
import xyz.tcheeric.cashu.common.Mint;
import xyz.tcheeric.cashu.common.PaymentMethod;
import xyz.tcheeric.cashu.common.PrivateKey;
import xyz.tcheeric.cashu.common.Proof;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.common.util.CashuErrorException;
import xyz.tcheeric.cashu.vault.api.VaultClientFactory;
import xyz.tcheeric.cashu.vault.api.db.impl.DBKeyVault;
import xyz.tcheeric.cashu.vault.db.client.KeySetVaultClient;
import xyz.tcheeric.cashu.vault.db.model.KeyEntity;
import xyz.tcheeric.cashu.vault.db.model.KeySetEntity;
import xyz.tcheeric.cashu.vault.db.model.MintEntity;
import xyz.tcheeric.cashu.vault.db.model.ProofEntity;
import xyz.tcheeric.gateway.common.Gateway;

public class MintProtocolUtil {
    private static final Logger log = LoggerFactory.getLogger(MintProtocolUtil.class);

    public static Gateway createGateway(@NonNull PaymentMethod method) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        return MintProtocolUtil.createGateway(method, null);
    }

    public static Gateway createGateway(@NonNull PaymentMethod method, String unit) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        try {
            Gateway gateway = GatewayLoader.loadGateway(method, unit);
            if (!gateway.supports(method)) {
                throw new IllegalArgumentException("Gateway does not support payment method: " + String.valueOf(method));
            }
            return gateway;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create gateway instance", e);
        }
    }

    public static PrivateKey getPrivateKey(@NonNull String keySetId, @NonNull Integer amount, @NonNull Mint mint) throws CashuErrorException {
        KeySetVaultClient ksc;
        KeySetEntity kse;
        if (keySetId == null) {
            throw new NullPointerException("keySetId is marked non-null but is null");
        }
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        if (mint == null) {
            throw new NullPointerException("mint is marked non-null but is null");
        }
        if (log.isDebugEnabled()) {
            log.debug("Resolve private key: externalKeySetId={} amount={}", (Object)keySetId, (Object)amount);
        }
        if ((kse = (ksc = VaultClientFactory.keySetClient()).getByKeySetId(keySetId)) == null || kse.getId() == null) {
            throw new CashuErrorException("keyset_not_found");
        }
        DBKeyVault keyVault = new DBKeyVault();
        KeyEntity keyEntity = keyVault.retrieveByAmount(BigInteger.valueOf(amount.intValue()), kse.getId().toString());
        PrivateKey pk = PrivateKey.fromString((String)keyEntity.getPrivateKey());
        if (log.isDebugEnabled()) {
            log.debug("Resolved private key for amount={} internalKeySetUUID={}", (Object)amount, (Object)kse.getId());
        }
        return pk;
    }

    public static String getCurrencyCode(@NonNull PaymentMethod paymentMethod) {
        if (paymentMethod == null) {
            throw new NullPointerException("paymentMethod is marked non-null but is null");
        }
        return switch (paymentMethod) {
            case PaymentMethod.BOLT11, PaymentMethod.BOLT12, PaymentMethod.ON_CHAIN -> "BTC";
            default -> "USD";
        };
    }

    public static String createLightningAddressRequest(@NonNull String lnAddress, @NonNull Integer amount, String description) {
        if (lnAddress == null) {
            throw new NullPointerException("lnAddress is marked non-null but is null");
        }
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        try {
            HashMap<String, Object> requestMap = new HashMap<String, Object>();
            requestMap.put("lnAddress", lnAddress);
            requestMap.put("amount", amount);
            requestMap.put("description", description);
            ObjectMapper objectMapper = new ObjectMapper();
            String jsonString = objectMapper.writeValueAsString(requestMap);
            return Base64.getEncoder().encodeToString(jsonString.getBytes());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create Lightning address request", e);
        }
    }

    public static MintEntity toMintEntity(@NonNull Mint mint) {
        if (mint == null) {
            throw new NullPointerException("mint is marked non-null but is null");
        }
        MintEntity mintEntity = new MintEntity();
        mintEntity.setId(UUID.fromString(mint.getId()));
        mint.getKeySets().forEach(keySet -> {
            KeySetEntity keySetEntity = MintProtocolUtil.toKeySetEntity(keySet);
            keySetEntity.setMint(mintEntity);
            mintEntity.getKeySets().add(keySetEntity);
        });
        return mintEntity;
    }

    public static KeySetEntity toKeySetEntity(@NonNull KeySet keySet) {
        if (keySet == null) {
            throw new NullPointerException("keySet is marked non-null but is null");
        }
        KeySetEntity keySetEntity = new KeySetEntity();
        keySetEntity.setKeySetId(keySet.getId());
        keySetEntity.setUnit(keySet.getUnit());
        return keySetEntity;
    }

    public static Keys toKeys(@NonNull Set<KeyEntity> keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        Keys result = new Keys();
        for (KeyEntity keyEntity : keys) {
            result.put(keyEntity.getAmount(), PrivateKey.derivePublicKey((PrivateKey)PrivateKey.fromString((String)keyEntity.getPrivateKey())));
        }
        return result;
    }

    public static <T extends Secret> ProofEntity toProofEntity(@NonNull Proof<T> proof, @NonNull MintEntity mintEntity) {
        if (proof == null) {
            throw new NullPointerException("proof is marked non-null but is null");
        }
        if (mintEntity == null) {
            throw new NullPointerException("mintEntity is marked non-null but is null");
        }
        ProofEntity proofEntity = new ProofEntity();
        proofEntity.setAmount(Integer.valueOf(proof.getAmount()));
        proofEntity.setSecret(proof.getSecret().toString());
        proofEntity.setWitness(proof.getWitness().toString());
        proofEntity.setUnblindedSignature(proof.getUnblindedSignature().toString());
        proofEntity.setMint(mintEntity);
        proofEntity.setState("SPENT");
        return proofEntity;
    }

    public static String createRandomBytes(int length) {
        byte[] randomBytes = new byte[length];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(randomBytes);
        StringBuilder hexString = new StringBuilder();
        for (byte b : randomBytes) {
            hexString.append(String.format("%02x", b));
        }
        return hexString.toString();
    }

    static class GatewayLoader {
        GatewayLoader() {
        }

        public static Gateway loadGateway(@NonNull PaymentMethod method, String unit) throws Exception {
            if (method == null) {
                throw new NullPointerException("method is marked non-null but is null");
            }
            Properties properties = new Properties();
            try (InputStream input = GatewayLoader.class.getClassLoader().getResourceAsStream("proto.properties");){
                if (input == null) {
                    throw new RuntimeException("Failed to load properties file");
                }
                properties.load(input);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load properties file", e);
            }
            String methodKey = method.name().toLowerCase();
            String gatewayClassName = null;
            if (unit != null && !unit.isBlank()) {
                String envWithUnit = ("GATEWAY_" + methodKey + "_" + unit).toUpperCase();
                gatewayClassName = System.getenv(envWithUnit);
            }
            if (gatewayClassName == null || gatewayClassName.isBlank()) {
                String envGeneric = ("GATEWAY_" + methodKey).toUpperCase();
                gatewayClassName = System.getenv(envGeneric);
            }
            if ((gatewayClassName == null || gatewayClassName.isBlank()) && unit != null && !unit.isBlank()) {
                String keyWithUnit = "gateway." + methodKey + "." + unit.toLowerCase();
                gatewayClassName = properties.getProperty(keyWithUnit);
            }
            if (gatewayClassName == null || gatewayClassName.isBlank()) {
                String key = "gateway." + methodKey;
                gatewayClassName = properties.getProperty(key);
            }
            if (gatewayClassName == null || gatewayClassName.isBlank()) {
                throw new IllegalArgumentException("Gateway class not specified for method " + String.valueOf(method) + (String)(unit != null ? " and unit " + unit : ""));
            }
            Class<?> gatewayClass = Class.forName(gatewayClassName);
            if (!Gateway.class.isAssignableFrom(gatewayClass)) {
                throw new IllegalArgumentException("Configured gateway does not implement Gateway: " + gatewayClassName);
            }
            return (Gateway)gatewayClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
    }
}

