/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.proto.tasks;

import java.util.ArrayList;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.common.BlindSignature;
import xyz.tcheeric.cashu.common.BlindedMessage;
import xyz.tcheeric.cashu.common.Mint;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.common.util.CashuErrorException;
import xyz.tcheeric.cashu.common.util.Task;
import xyz.tcheeric.cashu.entities.rest.ErrorResponse;
import xyz.tcheeric.cashu.entities.rest.PostSwapRequest;
import xyz.tcheeric.cashu.entities.rest.PostSwapResponse;
import xyz.tcheeric.cashu.mint.proto.service.DefaultMintLoadService;
import xyz.tcheeric.cashu.mint.proto.service.MintLoadService;
import xyz.tcheeric.cashu.mint.proto.service.MintProtocolService;
import xyz.tcheeric.cashu.mint.proto.service.MintProtocolServiceFactory;
import xyz.tcheeric.cashu.mint.proto.tasks.InvalidateProofsTask;
import xyz.tcheeric.cashu.mint.proto.tasks.SignBlindedMessageTask;
import xyz.tcheeric.cashu.mint.proto.tasks.VerifyFeesTask;
import xyz.tcheeric.cashu.mint.proto.tasks.VerifyProofsTask;

public class SwapTask<T extends Secret>
implements Task<PostSwapResponse> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SwapTask.class);
    private final UUID mintId;
    private final PostSwapRequest<T> request;
    private final MintLoadService mintLoadService;

    public SwapTask(@NonNull UUID mintId, @NonNull PostSwapRequest<T> request) {
        this(mintId, request, new DefaultMintLoadService());
        if (mintId == null) {
            throw new NullPointerException("mintId is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
    }

    public SwapTask(@NonNull UUID mintId, @NonNull PostSwapRequest<T> request, @NonNull MintLoadService mintLoadService) {
        if (mintId == null) {
            throw new NullPointerException("mintId is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (mintLoadService == null) {
            throw new NullPointerException("mintLoadService is marked non-null but is null");
        }
        this.mintId = mintId;
        this.request = request;
        this.mintLoadService = mintLoadService;
    }

    public PostSwapResponse execute() throws CashuErrorException {
        Mint mint = this.mintLoadService.load(this.mintId, false);
        if (mint == null) {
            ErrorResponse error = new ErrorResponse("swap_mint_not_found");
            throw new CashuErrorException(error.toJson());
        }
        MintProtocolService service = MintProtocolServiceFactory.getInstance();
        new VerifyProofsTask<T>(mint, this.request, service).execute();
        ArrayList<BlindSignature> blindSignatures = new ArrayList<BlindSignature>();
        for (BlindedMessage bm : this.request.getBlindedMessages()) {
            BlindSignature sig = new SignBlindedMessageTask(mint, bm, service).execute();
            blindSignatures.add(sig);
        }
        PostSwapResponse response = new PostSwapResponse(blindSignatures);
        new VerifyFeesTask<T>(this.request, response, this.mintLoadService).execute();
        new InvalidateProofsTask(mint, this.request.getInputs()).execute();
        return response;
    }
}

